@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin

import com.pulumi.azurenative.storagecache.StorageTargetArgs.builder
import com.pulumi.azurenative.storagecache.kotlin.enums.OperationalStateType
import com.pulumi.azurenative.storagecache.kotlin.enums.StorageTargetType
import com.pulumi.azurenative.storagecache.kotlin.inputs.BlobNfsTargetArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.BlobNfsTargetArgsBuilder
import com.pulumi.azurenative.storagecache.kotlin.inputs.ClfsTargetArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.ClfsTargetArgsBuilder
import com.pulumi.azurenative.storagecache.kotlin.inputs.NamespaceJunctionArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.NamespaceJunctionArgsBuilder
import com.pulumi.azurenative.storagecache.kotlin.inputs.Nfs3TargetArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.Nfs3TargetArgsBuilder
import com.pulumi.azurenative.storagecache.kotlin.inputs.UnknownTargetArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.UnknownTargetArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Type of the Storage Target.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2019-11-01, 2021-03-01.
 * ## Example Usage
 * ### StorageTargets_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageTarget = new AzureNative.StorageCache.StorageTarget("storageTarget", new()
 *     {
 *         CacheName = "sc1",
 *         Junctions = new[]
 *         {
 *             new AzureNative.StorageCache.Inputs.NamespaceJunctionArgs
 *             {
 *                 NamespacePath = "/path/on/cache",
 *                 NfsAccessPolicy = "default",
 *                 NfsExport = "exp1",
 *                 TargetPath = "/path/on/exp1",
 *             },
 *             new AzureNative.StorageCache.Inputs.NamespaceJunctionArgs
 *             {
 *                 NamespacePath = "/path2/on/cache",
 *                 NfsAccessPolicy = "rootSquash",
 *                 NfsExport = "exp2",
 *                 TargetPath = "/path2/on/exp2",
 *             },
 *         },
 *         Nfs3 = new AzureNative.StorageCache.Inputs.Nfs3TargetArgs
 *         {
 *             Target = "10.0.44.44",
 *             UsageModel = "READ_ONLY",
 *             VerificationTimer = 30,
 *         },
 *         ResourceGroupName = "scgroup",
 *         StorageTargetName = "st1",
 *         TargetType = "nfs3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagecache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagecache.NewStorageTarget(ctx, "storageTarget", &storagecache.StorageTargetArgs{
 * 			CacheName: pulumi.String("sc1"),
 * 			Junctions: []storagecache.NamespaceJunctionArgs{
 * 				{
 * 					NamespacePath:   pulumi.String("/path/on/cache"),
 * 					NfsAccessPolicy: pulumi.String("default"),
 * 					NfsExport:       pulumi.String("exp1"),
 * 					TargetPath:      pulumi.String("/path/on/exp1"),
 * 				},
 * 				{
 * 					NamespacePath:   pulumi.String("/path2/on/cache"),
 * 					NfsAccessPolicy: pulumi.String("rootSquash"),
 * 					NfsExport:       pulumi.String("exp2"),
 * 					TargetPath:      pulumi.String("/path2/on/exp2"),
 * 				},
 * 			},
 * 			Nfs3: &storagecache.Nfs3TargetArgs{
 * 				Target:            pulumi.String("10.0.44.44"),
 * 				UsageModel:        pulumi.String("READ_ONLY"),
 * 				VerificationTimer: pulumi.Int(30),
 * 			},
 * 			ResourceGroupName: pulumi.String("scgroup"),
 * 			StorageTargetName: pulumi.String("st1"),
 * 			TargetType:        pulumi.String("nfs3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagecache.StorageTarget;
 * import com.pulumi.azurenative.storagecache.StorageTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageTarget = new StorageTarget("storageTarget", StorageTargetArgs.builder()
 *             .cacheName("sc1")
 *             .junctions(
 *                 Map.ofEntries(
 *                     Map.entry("namespacePath", "/path/on/cache"),
 *                     Map.entry("nfsAccessPolicy", "default"),
 *                     Map.entry("nfsExport", "exp1"),
 *                     Map.entry("targetPath", "/path/on/exp1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("namespacePath", "/path2/on/cache"),
 *                     Map.entry("nfsAccessPolicy", "rootSquash"),
 *                     Map.entry("nfsExport", "exp2"),
 *                     Map.entry("targetPath", "/path2/on/exp2")
 *                 ))
 *             .nfs3(Map.ofEntries(
 *                 Map.entry("target", "10.0.44.44"),
 *                 Map.entry("usageModel", "READ_ONLY"),
 *                 Map.entry("verificationTimer", 30)
 *             ))
 *             .resourceGroupName("scgroup")
 *             .storageTargetName("st1")
 *             .targetType("nfs3")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageTargets_CreateOrUpdate_BlobNfs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageTarget = new AzureNative.StorageCache.StorageTarget("storageTarget", new()
 *     {
 *         BlobNfs = new AzureNative.StorageCache.Inputs.BlobNfsTargetArgs
 *         {
 *             Target = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.Storage/storageAccounts/blofnfs/blobServices/default/containers/blobnfs",
 *             UsageModel = "READ_WRITE",
 *             VerificationTimer = 28800,
 *             WriteBackTimer = 3600,
 *         },
 *         CacheName = "sc1",
 *         Junctions = new[]
 *         {
 *             new AzureNative.StorageCache.Inputs.NamespaceJunctionArgs
 *             {
 *                 NamespacePath = "/blobnfs",
 *             },
 *         },
 *         ResourceGroupName = "scgroup",
 *         StorageTargetName = "st1",
 *         TargetType = "blobNfs",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagecache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagecache.NewStorageTarget(ctx, "storageTarget", &storagecache.StorageTargetArgs{
 * 			BlobNfs: &storagecache.BlobNfsTargetArgs{
 * 				Target:            pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.Storage/storageAccounts/blofnfs/blobServices/default/containers/blobnfs"),
 * 				UsageModel:        pulumi.String("READ_WRITE"),
 * 				VerificationTimer: pulumi.Int(28800),
 * 				WriteBackTimer:    pulumi.Int(3600),
 * 			},
 * 			CacheName: pulumi.String("sc1"),
 * 			Junctions: []storagecache.NamespaceJunctionArgs{
 * 				{
 * 					NamespacePath: pulumi.String("/blobnfs"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("scgroup"),
 * 			StorageTargetName: pulumi.String("st1"),
 * 			TargetType:        pulumi.String("blobNfs"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagecache.StorageTarget;
 * import com.pulumi.azurenative.storagecache.StorageTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageTarget = new StorageTarget("storageTarget", StorageTargetArgs.builder()
 *             .blobNfs(Map.ofEntries(
 *                 Map.entry("target", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.Storage/storageAccounts/blofnfs/blobServices/default/containers/blobnfs"),
 *                 Map.entry("usageModel", "READ_WRITE"),
 *                 Map.entry("verificationTimer", 28800),
 *                 Map.entry("writeBackTimer", 3600)
 *             ))
 *             .cacheName("sc1")
 *             .junctions(Map.of("namespacePath", "/blobnfs"))
 *             .resourceGroupName("scgroup")
 *             .storageTargetName("st1")
 *             .targetType("blobNfs")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageTargets_CreateOrUpdate_NoJunctions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageTarget = new AzureNative.StorageCache.StorageTarget("storageTarget", new()
 *     {
 *         CacheName = "sc1",
 *         Nfs3 = new AzureNative.StorageCache.Inputs.Nfs3TargetArgs
 *         {
 *             Target = "10.0.44.44",
 *             UsageModel = "READ_ONLY",
 *             VerificationTimer = 30,
 *         },
 *         ResourceGroupName = "scgroup",
 *         StorageTargetName = "st1",
 *         TargetType = "nfs3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagecache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagecache.NewStorageTarget(ctx, "storageTarget", &storagecache.StorageTargetArgs{
 * 			CacheName: pulumi.String("sc1"),
 * 			Nfs3: &storagecache.Nfs3TargetArgs{
 * 				Target:            pulumi.String("10.0.44.44"),
 * 				UsageModel:        pulumi.String("READ_ONLY"),
 * 				VerificationTimer: pulumi.Int(30),
 * 			},
 * 			ResourceGroupName: pulumi.String("scgroup"),
 * 			StorageTargetName: pulumi.String("st1"),
 * 			TargetType:        pulumi.String("nfs3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagecache.StorageTarget;
 * import com.pulumi.azurenative.storagecache.StorageTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageTarget = new StorageTarget("storageTarget", StorageTargetArgs.builder()
 *             .cacheName("sc1")
 *             .nfs3(Map.ofEntries(
 *                 Map.entry("target", "10.0.44.44"),
 *                 Map.entry("usageModel", "READ_ONLY"),
 *                 Map.entry("verificationTimer", 30)
 *             ))
 *             .resourceGroupName("scgroup")
 *             .storageTargetName("st1")
 *             .targetType("nfs3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagecache:StorageTarget st1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}
 * ```
 * @property blobNfs Properties when targetType is blobNfs.
 * @property cacheName Name of cache. Length of name must not be greater than 80 and chars must be from the [-0-9a-zA-Z_] char class.
 * @property clfs Properties when targetType is clfs.
 * @property junctions List of cache namespace junctions to target for namespace associations.
 * @property nfs3 Properties when targetType is nfs3.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property state Storage target operational state.
 * @property storageTargetName Name of Storage Target.
 * @property targetType Type of the Storage Target.
 * @property unknown Properties when targetType is unknown.
 */
public data class StorageTargetArgs(
    public val blobNfs: Output<BlobNfsTargetArgs>? = null,
    public val cacheName: Output<String>? = null,
    public val clfs: Output<ClfsTargetArgs>? = null,
    public val junctions: Output<List<NamespaceJunctionArgs>>? = null,
    public val nfs3: Output<Nfs3TargetArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val state: Output<Either<String, OperationalStateType>>? = null,
    public val storageTargetName: Output<String>? = null,
    public val targetType: Output<Either<String, StorageTargetType>>? = null,
    public val unknown: Output<UnknownTargetArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.StorageTargetArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.StorageTargetArgs =
        com.pulumi.azurenative.storagecache.StorageTargetArgs.builder()
            .blobNfs(blobNfs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cacheName(cacheName?.applyValue({ args0 -> args0 }))
            .clfs(clfs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .junctions(
                junctions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .nfs3(nfs3?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageTargetName(storageTargetName?.applyValue({ args0 -> args0 }))
            .targetType(
                targetType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .unknown(unknown?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [StorageTargetArgs].
 */
@PulumiTagMarker
public class StorageTargetArgsBuilder internal constructor() {
    private var blobNfs: Output<BlobNfsTargetArgs>? = null

    private var cacheName: Output<String>? = null

    private var clfs: Output<ClfsTargetArgs>? = null

    private var junctions: Output<List<NamespaceJunctionArgs>>? = null

    private var nfs3: Output<Nfs3TargetArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var state: Output<Either<String, OperationalStateType>>? = null

    private var storageTargetName: Output<String>? = null

    private var targetType: Output<Either<String, StorageTargetType>>? = null

    private var unknown: Output<UnknownTargetArgs>? = null

    /**
     * @param value Properties when targetType is blobNfs.
     */
    @JvmName("ocirogpndqvqaauo")
    public suspend fun blobNfs(`value`: Output<BlobNfsTargetArgs>) {
        this.blobNfs = value
    }

    /**
     * @param value Name of cache. Length of name must not be greater than 80 and chars must be from the [-0-9a-zA-Z_] char class.
     */
    @JvmName("daqspfwbbpnaqujs")
    public suspend fun cacheName(`value`: Output<String>) {
        this.cacheName = value
    }

    /**
     * @param value Properties when targetType is clfs.
     */
    @JvmName("rovocipakbemerfa")
    public suspend fun clfs(`value`: Output<ClfsTargetArgs>) {
        this.clfs = value
    }

    /**
     * @param value List of cache namespace junctions to target for namespace associations.
     */
    @JvmName("ehagvelglhkodxpv")
    public suspend fun junctions(`value`: Output<List<NamespaceJunctionArgs>>) {
        this.junctions = value
    }

    @JvmName("miequkueayypcjef")
    public suspend fun junctions(vararg values: Output<NamespaceJunctionArgs>) {
        this.junctions = Output.all(values.asList())
    }

    /**
     * @param values List of cache namespace junctions to target for namespace associations.
     */
    @JvmName("ytympeylvkbawoio")
    public suspend fun junctions(values: List<Output<NamespaceJunctionArgs>>) {
        this.junctions = Output.all(values)
    }

    /**
     * @param value Properties when targetType is nfs3.
     */
    @JvmName("bssnnhhcughblmsu")
    public suspend fun nfs3(`value`: Output<Nfs3TargetArgs>) {
        this.nfs3 = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dvaphxxiaxfyuroy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Storage target operational state.
     */
    @JvmName("orbqihkvriwgraxx")
    public suspend fun state(`value`: Output<Either<String, OperationalStateType>>) {
        this.state = value
    }

    /**
     * @param value Name of Storage Target.
     */
    @JvmName("aucnxahikjudmreq")
    public suspend fun storageTargetName(`value`: Output<String>) {
        this.storageTargetName = value
    }

    /**
     * @param value Type of the Storage Target.
     */
    @JvmName("vowompvohlnnhqig")
    public suspend fun targetType(`value`: Output<Either<String, StorageTargetType>>) {
        this.targetType = value
    }

    /**
     * @param value Properties when targetType is unknown.
     */
    @JvmName("uwvmuhsimytixtui")
    public suspend fun unknown(`value`: Output<UnknownTargetArgs>) {
        this.unknown = value
    }

    /**
     * @param value Properties when targetType is blobNfs.
     */
    @JvmName("ginonqrlykifvrgx")
    public suspend fun blobNfs(`value`: BlobNfsTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobNfs = mapped
    }

    /**
     * @param argument Properties when targetType is blobNfs.
     */
    @JvmName("ehkrkcraphggetbi")
    public suspend fun blobNfs(argument: suspend BlobNfsTargetArgsBuilder.() -> Unit) {
        val toBeMapped = BlobNfsTargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.blobNfs = mapped
    }

    /**
     * @param value Name of cache. Length of name must not be greater than 80 and chars must be from the [-0-9a-zA-Z_] char class.
     */
    @JvmName("pmdbnpogvccfdnal")
    public suspend fun cacheName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheName = mapped
    }

    /**
     * @param value Properties when targetType is clfs.
     */
    @JvmName("lolcxkwabuaaqgny")
    public suspend fun clfs(`value`: ClfsTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clfs = mapped
    }

    /**
     * @param argument Properties when targetType is clfs.
     */
    @JvmName("ojjlmurftpdrkylx")
    public suspend fun clfs(argument: suspend ClfsTargetArgsBuilder.() -> Unit) {
        val toBeMapped = ClfsTargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clfs = mapped
    }

    /**
     * @param value List of cache namespace junctions to target for namespace associations.
     */
    @JvmName("bwbflyrdhqbxecjk")
    public suspend fun junctions(`value`: List<NamespaceJunctionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.junctions = mapped
    }

    /**
     * @param argument List of cache namespace junctions to target for namespace associations.
     */
    @JvmName("usqipjtppvjddqnh")
    public suspend fun junctions(argument: List<suspend NamespaceJunctionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NamespaceJunctionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.junctions = mapped
    }

    /**
     * @param argument List of cache namespace junctions to target for namespace associations.
     */
    @JvmName("pcqnbrukenagaada")
    public suspend fun junctions(vararg argument: suspend NamespaceJunctionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NamespaceJunctionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.junctions = mapped
    }

    /**
     * @param argument List of cache namespace junctions to target for namespace associations.
     */
    @JvmName("dablnrqqbsxqnfmc")
    public suspend fun junctions(argument: suspend NamespaceJunctionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NamespaceJunctionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.junctions = mapped
    }

    /**
     * @param values List of cache namespace junctions to target for namespace associations.
     */
    @JvmName("xycgflykwfhqgruc")
    public suspend fun junctions(vararg values: NamespaceJunctionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.junctions = mapped
    }

    /**
     * @param value Properties when targetType is nfs3.
     */
    @JvmName("gmwwmpwubkcerime")
    public suspend fun nfs3(`value`: Nfs3TargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfs3 = mapped
    }

    /**
     * @param argument Properties when targetType is nfs3.
     */
    @JvmName("tknjmwnyorwshmoh")
    public suspend fun nfs3(argument: suspend Nfs3TargetArgsBuilder.() -> Unit) {
        val toBeMapped = Nfs3TargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nfs3 = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ohnljvevjnkuwsai")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Storage target operational state.
     */
    @JvmName("ipvtfithnuuptyhc")
    public suspend fun state(`value`: Either<String, OperationalStateType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Storage target operational state.
     */
    @JvmName("vnoqejnpgwjwpejb")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperationalStateType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Storage target operational state.
     */
    @JvmName("cmtcbklbeqihrsoy")
    public fun state(`value`: OperationalStateType) {
        val toBeMapped = Either.ofRight<String, OperationalStateType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Name of Storage Target.
     */
    @JvmName("aunpjbohvcgkokkt")
    public suspend fun storageTargetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageTargetName = mapped
    }

    /**
     * @param value Type of the Storage Target.
     */
    @JvmName("lgwudnixuwlrnqmg")
    public suspend fun targetType(`value`: Either<String, StorageTargetType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    /**
     * @param value Type of the Storage Target.
     */
    @JvmName("sakfxvkngswjgrsj")
    public fun targetType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageTargetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    /**
     * @param value Type of the Storage Target.
     */
    @JvmName("xlnbxxlckqkbbmef")
    public fun targetType(`value`: StorageTargetType) {
        val toBeMapped = Either.ofRight<String, StorageTargetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    /**
     * @param value Properties when targetType is unknown.
     */
    @JvmName("dweyxquhotyredwr")
    public suspend fun unknown(`value`: UnknownTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unknown = mapped
    }

    /**
     * @param argument Properties when targetType is unknown.
     */
    @JvmName("asvbwhkwulhfobnn")
    public suspend fun unknown(argument: suspend UnknownTargetArgsBuilder.() -> Unit) {
        val toBeMapped = UnknownTargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.unknown = mapped
    }

    internal fun build(): StorageTargetArgs = StorageTargetArgs(
        blobNfs = blobNfs,
        cacheName = cacheName,
        clfs = clfs,
        junctions = junctions,
        nfs3 = nfs3,
        resourceGroupName = resourceGroupName,
        state = state,
        storageTargetName = storageTargetName,
        targetType = targetType,
        unknown = unknown,
    )
}
