@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Storage target operational state.
 */
public enum class OperationalStateType(
    public val javaValue: com.pulumi.azurenative.storagecache.enums.OperationalStateType,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.enums.OperationalStateType> {
    Ready(com.pulumi.azurenative.storagecache.enums.OperationalStateType.Ready),
    Busy(com.pulumi.azurenative.storagecache.enums.OperationalStateType.Busy),
    Suspended(com.pulumi.azurenative.storagecache.enums.OperationalStateType.Suspended),
    Flushing(com.pulumi.azurenative.storagecache.enums.OperationalStateType.Flushing),
    ;

    override fun toJava(): com.pulumi.azurenative.storagecache.enums.OperationalStateType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.enums.OperationalStateType):
            OperationalStateType = OperationalStateType.values().first { it.javaValue == javaType }
    }
}
