@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This setting determines how the cache gets username and group names for clients.
 */
public enum class UsernameSource(
    public val javaValue: com.pulumi.azurenative.storagecache.enums.UsernameSource,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.enums.UsernameSource> {
    AD(com.pulumi.azurenative.storagecache.enums.UsernameSource.AD),
    LDAP(com.pulumi.azurenative.storagecache.enums.UsernameSource.LDAP),
    File(com.pulumi.azurenative.storagecache.enums.UsernameSource.File),
    None(com.pulumi.azurenative.storagecache.enums.UsernameSource.None),
    ;

    override fun toJava(): com.pulumi.azurenative.storagecache.enums.UsernameSource = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.enums.UsernameSource):
            UsernameSource = UsernameSource.values().first { it.javaValue == javaType }
    }
}
