@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.AmlFilesystemIdentityArgs.builder
import com.pulumi.azurenative.storagecache.kotlin.enums.AmlFilesystemIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Managed Identity properties.
 * @property type The type of identity used for the resource.
 * @property userAssignedIdentities A dictionary where each key is a user assigned identity resource ID, and each key's value is an empty dictionary.
 */
public data class AmlFilesystemIdentityArgs(
    public val type: Output<AmlFilesystemIdentityType>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.AmlFilesystemIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.AmlFilesystemIdentityArgs =
        com.pulumi.azurenative.storagecache.inputs.AmlFilesystemIdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [AmlFilesystemIdentityArgs].
 */
@PulumiTagMarker
public class AmlFilesystemIdentityArgsBuilder internal constructor() {
    private var type: Output<AmlFilesystemIdentityType>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The type of identity used for the resource.
     */
    @JvmName("agwlbvlobjsyorlm")
    public suspend fun type(`value`: Output<AmlFilesystemIdentityType>) {
        this.type = value
    }

    /**
     * @param value A dictionary where each key is a user assigned identity resource ID, and each key's value is an empty dictionary.
     */
    @JvmName("lhhvixmemnataiiq")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("psdpcjifvuatmajl")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values A dictionary where each key is a user assigned identity resource ID, and each key's value is an empty dictionary.
     */
    @JvmName("ykcqweopqakpoxsr")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The type of identity used for the resource.
     */
    @JvmName("gqpwkrxmyfdutkcp")
    public suspend fun type(`value`: AmlFilesystemIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value A dictionary where each key is a user assigned identity resource ID, and each key's value is an empty dictionary.
     */
    @JvmName("tpeqdrudrcaxrlna")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values A dictionary where each key is a user assigned identity resource ID, and each key's value is an empty dictionary.
     */
    @JvmName("jykskdfbaeuanhbv")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): AmlFilesystemIdentityArgs = AmlFilesystemIdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
