@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.CacheNetworkSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Cache network settings.
 * @property dnsSearchDomain DNS search domain
 * @property dnsServers DNS servers for the cache to use.  It will be set from the network configuration if no value is provided.
 * @property mtu The IPv4 maximum transmission unit configured for the subnet.
 * @property ntpServer NTP server IP Address or FQDN for the cache to use. The default is time.windows.com.
 */
public data class CacheNetworkSettingsArgs(
    public val dnsSearchDomain: Output<String>? = null,
    public val dnsServers: Output<List<String>>? = null,
    public val mtu: Output<Int>? = null,
    public val ntpServer: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.CacheNetworkSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.CacheNetworkSettingsArgs =
        com.pulumi.azurenative.storagecache.inputs.CacheNetworkSettingsArgs.builder()
            .dnsSearchDomain(dnsSearchDomain?.applyValue({ args0 -> args0 }))
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .mtu(mtu?.applyValue({ args0 -> args0 }))
            .ntpServer(ntpServer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CacheNetworkSettingsArgs].
 */
@PulumiTagMarker
public class CacheNetworkSettingsArgsBuilder internal constructor() {
    private var dnsSearchDomain: Output<String>? = null

    private var dnsServers: Output<List<String>>? = null

    private var mtu: Output<Int>? = null

    private var ntpServer: Output<String>? = null

    /**
     * @param value DNS search domain
     */
    @JvmName("necvxgllokhmhrsg")
    public suspend fun dnsSearchDomain(`value`: Output<String>) {
        this.dnsSearchDomain = value
    }

    /**
     * @param value DNS servers for the cache to use.  It will be set from the network configuration if no value is provided.
     */
    @JvmName("kiqtdbjkbepnjypu")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("rcgwwnwmwlbxelgy")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values DNS servers for the cache to use.  It will be set from the network configuration if no value is provided.
     */
    @JvmName("rlbpplsrdvdpwpum")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value The IPv4 maximum transmission unit configured for the subnet.
     */
    @JvmName("giissjgcoffyscvr")
    public suspend fun mtu(`value`: Output<Int>) {
        this.mtu = value
    }

    /**
     * @param value NTP server IP Address or FQDN for the cache to use. The default is time.windows.com.
     */
    @JvmName("ngtrjqadfiikychq")
    public suspend fun ntpServer(`value`: Output<String>) {
        this.ntpServer = value
    }

    /**
     * @param value DNS search domain
     */
    @JvmName("dhbhoomdtfaqnlqj")
    public suspend fun dnsSearchDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSearchDomain = mapped
    }

    /**
     * @param value DNS servers for the cache to use.  It will be set from the network configuration if no value is provided.
     */
    @JvmName("rdlvumvktunffnjs")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values DNS servers for the cache to use.  It will be set from the network configuration if no value is provided.
     */
    @JvmName("ncnbuadcniifbmem")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param value The IPv4 maximum transmission unit configured for the subnet.
     */
    @JvmName("denvplyavdyjgxky")
    public suspend fun mtu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mtu = mapped
    }

    /**
     * @param value NTP server IP Address or FQDN for the cache to use. The default is time.windows.com.
     */
    @JvmName("aduifcunkwerripw")
    public suspend fun ntpServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ntpServer = mapped
    }

    internal fun build(): CacheNetworkSettingsArgs = CacheNetworkSettingsArgs(
        dnsSearchDomain = dnsSearchDomain,
        dnsServers = dnsServers,
        mtu = mtu,
        ntpServer = ntpServer,
    )
}
