@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.CacheSkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU for the cache.
 * @property name SKU name for this cache.
 */
public data class CacheSkuArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.CacheSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.CacheSkuArgs =
        com.pulumi.azurenative.storagecache.inputs.CacheSkuArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CacheSkuArgs].
 */
@PulumiTagMarker
public class CacheSkuArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value SKU name for this cache.
     */
    @JvmName("iwdvtvoxdfdugpto")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value SKU name for this cache.
     */
    @JvmName("summfvrehmnjxhid")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): CacheSkuArgs = CacheSkuArgs(
        name = name,
    )
}
