@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.CacheUsernameDownloadSettingsArgs.builder
import com.pulumi.azurenative.storagecache.kotlin.enums.UsernameSource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Settings for Extended Groups username and group download.
 * @property autoDownloadCertificate Determines if the certificate should be automatically downloaded. This applies to 'caCertificateURI' only if 'requireValidCertificate' is true.
 * @property caCertificateURI The URI of the CA certificate to validate the LDAP secure connection. This field must be populated when 'requireValidCertificate' is set to true.
 * @property credentials When present, these are the credentials for the secure LDAP connection.
 * @property encryptLdapConnection Whether or not the LDAP connection should be encrypted.
 * @property extendedGroups Whether or not Extended Groups is enabled.
 * @property groupFileURI The URI of the file containing group information (in /etc/group file format). This field must be populated when 'usernameSource' is set to 'File'.
 * @property ldapBaseDN The base distinguished name for the LDAP domain.
 * @property ldapServer The fully qualified domain name or IP address of the LDAP server to use.
 * @property requireValidCertificate Determines if the certificates must be validated by a certificate authority. When true, caCertificateURI must be provided.
 * @property userFileURI The URI of the file containing user information (in /etc/passwd file format). This field must be populated when 'usernameSource' is set to 'File'.
 * @property usernameSource This setting determines how the cache gets username and group names for clients.
 */
public data class CacheUsernameDownloadSettingsArgs(
    public val autoDownloadCertificate: Output<Boolean>? = null,
    public val caCertificateURI: Output<String>? = null,
    public val credentials: Output<CacheUsernameDownloadSettingsCredentialsArgs>? = null,
    public val encryptLdapConnection: Output<Boolean>? = null,
    public val extendedGroups: Output<Boolean>? = null,
    public val groupFileURI: Output<String>? = null,
    public val ldapBaseDN: Output<String>? = null,
    public val ldapServer: Output<String>? = null,
    public val requireValidCertificate: Output<Boolean>? = null,
    public val userFileURI: Output<String>? = null,
    public val usernameSource: Output<Either<String, UsernameSource>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.CacheUsernameDownloadSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.storagecache.inputs.CacheUsernameDownloadSettingsArgs =
        com.pulumi.azurenative.storagecache.inputs.CacheUsernameDownloadSettingsArgs.builder()
            .autoDownloadCertificate(autoDownloadCertificate?.applyValue({ args0 -> args0 }))
            .caCertificateURI(caCertificateURI?.applyValue({ args0 -> args0 }))
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encryptLdapConnection(encryptLdapConnection?.applyValue({ args0 -> args0 }))
            .extendedGroups(extendedGroups?.applyValue({ args0 -> args0 }))
            .groupFileURI(groupFileURI?.applyValue({ args0 -> args0 }))
            .ldapBaseDN(ldapBaseDN?.applyValue({ args0 -> args0 }))
            .ldapServer(ldapServer?.applyValue({ args0 -> args0 }))
            .requireValidCertificate(requireValidCertificate?.applyValue({ args0 -> args0 }))
            .userFileURI(userFileURI?.applyValue({ args0 -> args0 }))
            .usernameSource(
                usernameSource?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [CacheUsernameDownloadSettingsArgs].
 */
@PulumiTagMarker
public class CacheUsernameDownloadSettingsArgsBuilder internal constructor() {
    private var autoDownloadCertificate: Output<Boolean>? = null

    private var caCertificateURI: Output<String>? = null

    private var credentials: Output<CacheUsernameDownloadSettingsCredentialsArgs>? = null

    private var encryptLdapConnection: Output<Boolean>? = null

    private var extendedGroups: Output<Boolean>? = null

    private var groupFileURI: Output<String>? = null

    private var ldapBaseDN: Output<String>? = null

    private var ldapServer: Output<String>? = null

    private var requireValidCertificate: Output<Boolean>? = null

    private var userFileURI: Output<String>? = null

    private var usernameSource: Output<Either<String, UsernameSource>>? = null

    /**
     * @param value Determines if the certificate should be automatically downloaded. This applies to 'caCertificateURI' only if 'requireValidCertificate' is true.
     */
    @JvmName("jjdkwjcoftlabqox")
    public suspend fun autoDownloadCertificate(`value`: Output<Boolean>) {
        this.autoDownloadCertificate = value
    }

    /**
     * @param value The URI of the CA certificate to validate the LDAP secure connection. This field must be populated when 'requireValidCertificate' is set to true.
     */
    @JvmName("qqqcfrbyivqkhswo")
    public suspend fun caCertificateURI(`value`: Output<String>) {
        this.caCertificateURI = value
    }

    /**
     * @param value When present, these are the credentials for the secure LDAP connection.
     */
    @JvmName("ekymcsakyptxfang")
    public suspend fun credentials(`value`: Output<CacheUsernameDownloadSettingsCredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value Whether or not the LDAP connection should be encrypted.
     */
    @JvmName("oqygsbjwbwwnoiem")
    public suspend fun encryptLdapConnection(`value`: Output<Boolean>) {
        this.encryptLdapConnection = value
    }

    /**
     * @param value Whether or not Extended Groups is enabled.
     */
    @JvmName("fwvtecsrjanfekjl")
    public suspend fun extendedGroups(`value`: Output<Boolean>) {
        this.extendedGroups = value
    }

    /**
     * @param value The URI of the file containing group information (in /etc/group file format). This field must be populated when 'usernameSource' is set to 'File'.
     */
    @JvmName("gxygomoulixdquca")
    public suspend fun groupFileURI(`value`: Output<String>) {
        this.groupFileURI = value
    }

    /**
     * @param value The base distinguished name for the LDAP domain.
     */
    @JvmName("upieygjtrwkjhaqw")
    public suspend fun ldapBaseDN(`value`: Output<String>) {
        this.ldapBaseDN = value
    }

    /**
     * @param value The fully qualified domain name or IP address of the LDAP server to use.
     */
    @JvmName("eesbbwfvvphetswl")
    public suspend fun ldapServer(`value`: Output<String>) {
        this.ldapServer = value
    }

    /**
     * @param value Determines if the certificates must be validated by a certificate authority. When true, caCertificateURI must be provided.
     */
    @JvmName("clibjalcfpnxecsm")
    public suspend fun requireValidCertificate(`value`: Output<Boolean>) {
        this.requireValidCertificate = value
    }

    /**
     * @param value The URI of the file containing user information (in /etc/passwd file format). This field must be populated when 'usernameSource' is set to 'File'.
     */
    @JvmName("agysnemyrciinwhv")
    public suspend fun userFileURI(`value`: Output<String>) {
        this.userFileURI = value
    }

    /**
     * @param value This setting determines how the cache gets username and group names for clients.
     */
    @JvmName("ehgusawdwleflxvb")
    public suspend fun usernameSource(`value`: Output<Either<String, UsernameSource>>) {
        this.usernameSource = value
    }

    /**
     * @param value Determines if the certificate should be automatically downloaded. This applies to 'caCertificateURI' only if 'requireValidCertificate' is true.
     */
    @JvmName("eqjhgpqgdvqbbaxa")
    public suspend fun autoDownloadCertificate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDownloadCertificate = mapped
    }

    /**
     * @param value The URI of the CA certificate to validate the LDAP secure connection. This field must be populated when 'requireValidCertificate' is set to true.
     */
    @JvmName("bxduhfxbvwsskonj")
    public suspend fun caCertificateURI(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caCertificateURI = mapped
    }

    /**
     * @param value When present, these are the credentials for the secure LDAP connection.
     */
    @JvmName("xihxecgdyqgkvpyu")
    public suspend fun credentials(`value`: CacheUsernameDownloadSettingsCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument When present, these are the credentials for the secure LDAP connection.
     */
    @JvmName("llssujmbtrlpfhup")
    public suspend
    fun credentials(argument: suspend CacheUsernameDownloadSettingsCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = CacheUsernameDownloadSettingsCredentialsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value Whether or not the LDAP connection should be encrypted.
     */
    @JvmName("ggiojjmtyeyhyyyr")
    public suspend fun encryptLdapConnection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptLdapConnection = mapped
    }

    /**
     * @param value Whether or not Extended Groups is enabled.
     */
    @JvmName("ewjhaamlfeeflgts")
    public suspend fun extendedGroups(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedGroups = mapped
    }

    /**
     * @param value The URI of the file containing group information (in /etc/group file format). This field must be populated when 'usernameSource' is set to 'File'.
     */
    @JvmName("mgkugvvhaotflgjw")
    public suspend fun groupFileURI(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupFileURI = mapped
    }

    /**
     * @param value The base distinguished name for the LDAP domain.
     */
    @JvmName("rrnqcvfcunoiapvi")
    public suspend fun ldapBaseDN(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ldapBaseDN = mapped
    }

    /**
     * @param value The fully qualified domain name or IP address of the LDAP server to use.
     */
    @JvmName("yyyxljglkvayxych")
    public suspend fun ldapServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ldapServer = mapped
    }

    /**
     * @param value Determines if the certificates must be validated by a certificate authority. When true, caCertificateURI must be provided.
     */
    @JvmName("dvfllvsjshyckgha")
    public suspend fun requireValidCertificate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireValidCertificate = mapped
    }

    /**
     * @param value The URI of the file containing user information (in /etc/passwd file format). This field must be populated when 'usernameSource' is set to 'File'.
     */
    @JvmName("vluaudylgxikxthe")
    public suspend fun userFileURI(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userFileURI = mapped
    }

    /**
     * @param value This setting determines how the cache gets username and group names for clients.
     */
    @JvmName("qhhsrhwihjcwynsr")
    public suspend fun usernameSource(`value`: Either<String, UsernameSource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernameSource = mapped
    }

    /**
     * @param value This setting determines how the cache gets username and group names for clients.
     */
    @JvmName("wsyslxbnofpgnvjm")
    public fun usernameSource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UsernameSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usernameSource = mapped
    }

    /**
     * @param value This setting determines how the cache gets username and group names for clients.
     */
    @JvmName("fxcglwrarkvdpksn")
    public fun usernameSource(`value`: UsernameSource) {
        val toBeMapped = Either.ofRight<String, UsernameSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usernameSource = mapped
    }

    internal fun build(): CacheUsernameDownloadSettingsArgs = CacheUsernameDownloadSettingsArgs(
        autoDownloadCertificate = autoDownloadCertificate,
        caCertificateURI = caCertificateURI,
        credentials = credentials,
        encryptLdapConnection = encryptLdapConnection,
        extendedGroups = extendedGroups,
        groupFileURI = groupFileURI,
        ldapBaseDN = ldapBaseDN,
        ldapServer = ldapServer,
        requireValidCertificate = requireValidCertificate,
        userFileURI = userFileURI,
        usernameSource = usernameSource,
    )
}
