@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.GetRequiredAmlFSSubnetsSizePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sku SKU for the resource.
 * @property storageCapacityTiB The size of the AML file system, in TiB.
 */
public data class GetRequiredAmlFSSubnetsSizePlainArgs(
    public val sku: SkuName? = null,
    public val storageCapacityTiB: Double? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.GetRequiredAmlFSSubnetsSizePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.storagecache.inputs.GetRequiredAmlFSSubnetsSizePlainArgs =
        com.pulumi.azurenative.storagecache.inputs.GetRequiredAmlFSSubnetsSizePlainArgs.builder()
            .sku(sku?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageCapacityTiB(storageCapacityTiB?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRequiredAmlFSSubnetsSizePlainArgs].
 */
@PulumiTagMarker
public class GetRequiredAmlFSSubnetsSizePlainArgsBuilder internal constructor() {
    private var sku: SkuName? = null

    private var storageCapacityTiB: Double? = null

    /**
     * @param value SKU for the resource.
     */
    @JvmName("prmcfiegbdejcyqk")
    public suspend fun sku(`value`: SkuName?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sku = mapped
    }

    /**
     * @param argument SKU for the resource.
     */
    @JvmName("byfwkfgauojsbmrw")
    public suspend fun sku(argument: suspend SkuNameBuilder.() -> Unit) {
        val toBeMapped = SkuNameBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.sku = mapped
    }

    /**
     * @param value The size of the AML file system, in TiB.
     */
    @JvmName("hllybmacptajpbxk")
    public suspend fun storageCapacityTiB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.storageCapacityTiB = mapped
    }

    internal fun build(): GetRequiredAmlFSSubnetsSizePlainArgs = GetRequiredAmlFSSubnetsSizePlainArgs(
        sku = sku,
        storageCapacityTiB = storageCapacityTiB,
    )
}
