@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.Nfs3TargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties pertaining to the Nfs3Target
 * @property target IP address or host name of an NFSv3 host (e.g., 10.0.44.44).
 * @property usageModel Identifies the StorageCache usage model to be used for this storage target.
 * @property verificationTimer Amount of time (in seconds) the cache waits before it checks the back-end storage for file updates.
 * @property writeBackTimer Amount of time (in seconds) the cache waits after the last file change before it copies the changed file to back-end storage.
 */
public data class Nfs3TargetArgs(
    public val target: Output<String>? = null,
    public val usageModel: Output<String>? = null,
    public val verificationTimer: Output<Int>? = null,
    public val writeBackTimer: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.Nfs3TargetArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.Nfs3TargetArgs =
        com.pulumi.azurenative.storagecache.inputs.Nfs3TargetArgs.builder()
            .target(target?.applyValue({ args0 -> args0 }))
            .usageModel(usageModel?.applyValue({ args0 -> args0 }))
            .verificationTimer(verificationTimer?.applyValue({ args0 -> args0 }))
            .writeBackTimer(writeBackTimer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [Nfs3TargetArgs].
 */
@PulumiTagMarker
public class Nfs3TargetArgsBuilder internal constructor() {
    private var target: Output<String>? = null

    private var usageModel: Output<String>? = null

    private var verificationTimer: Output<Int>? = null

    private var writeBackTimer: Output<Int>? = null

    /**
     * @param value IP address or host name of an NFSv3 host (e.g., 10.0.44.44).
     */
    @JvmName("ctkgkxfkjxtwpsxq")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Identifies the StorageCache usage model to be used for this storage target.
     */
    @JvmName("snlebuhpmmfxylvr")
    public suspend fun usageModel(`value`: Output<String>) {
        this.usageModel = value
    }

    /**
     * @param value Amount of time (in seconds) the cache waits before it checks the back-end storage for file updates.
     */
    @JvmName("ogdsyitalvjfplbe")
    public suspend fun verificationTimer(`value`: Output<Int>) {
        this.verificationTimer = value
    }

    /**
     * @param value Amount of time (in seconds) the cache waits after the last file change before it copies the changed file to back-end storage.
     */
    @JvmName("dkkekcrfivngcurl")
    public suspend fun writeBackTimer(`value`: Output<Int>) {
        this.writeBackTimer = value
    }

    /**
     * @param value IP address or host name of an NFSv3 host (e.g., 10.0.44.44).
     */
    @JvmName("xtlqwipnjjdindhy")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Identifies the StorageCache usage model to be used for this storage target.
     */
    @JvmName("obfclecayltydfvn")
    public suspend fun usageModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usageModel = mapped
    }

    /**
     * @param value Amount of time (in seconds) the cache waits before it checks the back-end storage for file updates.
     */
    @JvmName("rfhalngisqkkccsa")
    public suspend fun verificationTimer(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verificationTimer = mapped
    }

    /**
     * @param value Amount of time (in seconds) the cache waits after the last file change before it copies the changed file to back-end storage.
     */
    @JvmName("xaolfuilifmgtcht")
    public suspend fun writeBackTimer(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBackTimer = mapped
    }

    internal fun build(): Nfs3TargetArgs = Nfs3TargetArgs(
        target = target,
        usageModel = usageModel,
        verificationTimer = verificationTimer,
        writeBackTimer = writeBackTimer,
    )
}
