@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An indication of cache health. Gives more information about health than just that related to provisioning.
 * @property conditions Outstanding conditions that need to be investigated and resolved.
 * @property state List of cache health states. Down is when the cluster is not responding.  Degraded is when its functioning but has some alerts. Transitioning when it is creating or deleting. Unknown will be returned in old api versions when a new value is added in future versions. WaitingForKey is when the create is waiting for the system assigned identity to be given access to the encryption key in the encryption settings.
 * @property statusDescription Describes explanation of state.
 */
public data class CacheHealthResponse(
    public val conditions: List<ConditionResponse>,
    public val state: String? = null,
    public val statusDescription: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.CacheHealthResponse):
            CacheHealthResponse = CacheHealthResponse(
            conditions = javaType.conditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.ConditionResponse.Companion.toKotlin(args0)
                })
            }),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            statusDescription = javaType.statusDescription().map({ args0 -> args0 }).orElse(null),
        )
    }
}
