@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An AML file system instance. Follows Azure Resource Manager standards: https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/resource-api-reference.md
 * @property clientInfo Client information for the AML file system.
 * @property encryptionSettings Specifies encryption settings of the AML file system.
 * @property filesystemSubnet Subnet used for managing the AML file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the VNET's address space.
 * @property health Health of the AML file system.
 * @property hsm Hydration and archive settings and status
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The managed identity used by the AML file system, if configured.
 * @property location The geo-location where the resource lives
 * @property maintenanceWindow Start time of a 30-minute weekly maintenance window.
 * @property name The name of the resource
 * @property provisioningState ARM provisioning state.
 * @property sku SKU for the resource.
 * @property storageCapacityTiB The size of the AML file system, in TiB. This might be rounded up.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property throughputProvisionedMBps Throughput provisioned in MB per sec, calculated as storageCapacityTiB * per-unit storage throughput
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property zones Availability zones for resources. This field should only contain a single element in the array.
 */
public data class GetAmlFilesystemResult(
    public val clientInfo: AmlFilesystemClientInfoResponse,
    public val encryptionSettings: AmlFilesystemEncryptionSettingsResponse? = null,
    public val filesystemSubnet: String,
    public val health: AmlFilesystemHealthResponse,
    public val hsm: AmlFilesystemResponseHsm? = null,
    public val id: String,
    public val identity: AmlFilesystemIdentityResponse? = null,
    public val location: String,
    public val maintenanceWindow: AmlFilesystemResponseMaintenanceWindow,
    public val name: String,
    public val provisioningState: String,
    public val sku: SkuNameResponse? = null,
    public val storageCapacityTiB: Double,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val throughputProvisionedMBps: Int,
    public val type: String,
    public val zones: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.GetAmlFilesystemResult):
            GetAmlFilesystemResult = GetAmlFilesystemResult(
            clientInfo = javaType.clientInfo().let({ args0 ->
                com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemClientInfoResponse.Companion.toKotlin(args0)
            }),
            encryptionSettings = javaType.encryptionSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemEncryptionSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            filesystemSubnet = javaType.filesystemSubnet(),
            health = javaType.health().let({ args0 ->
                com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemHealthResponse.Companion.toKotlin(args0)
            }),
            hsm = javaType.hsm().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemResponseHsm.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            maintenanceWindow = javaType.maintenanceWindow().let({ args0 ->
                com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemResponseMaintenanceWindow.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.SkuNameResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageCapacityTiB = javaType.storageCapacityTiB(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storagecache.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            throughputProvisionedMBps = javaType.throughputProvisionedMBps(),
            type = javaType.type(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
