@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin

import com.pulumi.azurenative.storagemover.AgentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Agent resource.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2022-07-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-10-01.
 * ## Example Usage
 * ### Agents_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agent = new AzureNative.StorageMover.Agent("agent", new()
 *     {
 *         AgentName = "examples-agentName",
 *         ArcResourceId = "/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/examples-rg/providers/Microsoft.HybridCompute/machines/examples-hybridComputeName",
 *         ArcVmUuid = "3bb2c024-eba9-4d18-9e7a-1d772fcc5fe9",
 *         Description = "Example Agent Description",
 *         ResourceGroupName = "examples-rg",
 *         StorageMoverName = "examples-storageMoverName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagemover/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagemover.NewAgent(ctx, "agent", &storagemover.AgentArgs{
 * 			AgentName:         pulumi.String("examples-agentName"),
 * 			ArcResourceId:     pulumi.String("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/examples-rg/providers/Microsoft.HybridCompute/machines/examples-hybridComputeName"),
 * 			ArcVmUuid:         pulumi.String("3bb2c024-eba9-4d18-9e7a-1d772fcc5fe9"),
 * 			Description:       pulumi.String("Example Agent Description"),
 * 			ResourceGroupName: pulumi.String("examples-rg"),
 * 			StorageMoverName:  pulumi.String("examples-storageMoverName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagemover.Agent;
 * import com.pulumi.azurenative.storagemover.AgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agent = new Agent("agent", AgentArgs.builder()
 *             .agentName("examples-agentName")
 *             .arcResourceId("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/examples-rg/providers/Microsoft.HybridCompute/machines/examples-hybridComputeName")
 *             .arcVmUuid("3bb2c024-eba9-4d18-9e7a-1d772fcc5fe9")
 *             .description("Example Agent Description")
 *             .resourceGroupName("examples-rg")
 *             .storageMoverName("examples-storageMoverName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagemover:Agent examples-agentName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageMover/storageMovers/{storageMoverName}/agents/{agentName}
 * ```
 * @property agentName The name of the Agent resource.
 * @property arcResourceId The fully qualified resource ID of the Hybrid Compute resource for the Agent.
 * @property arcVmUuid The VM UUID of the Hybrid Compute resource for the Agent.
 * @property description A description for the Agent.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageMoverName The name of the Storage Mover resource.
 */
public data class AgentArgs(
    public val agentName: Output<String>? = null,
    public val arcResourceId: Output<String>? = null,
    public val arcVmUuid: Output<String>? = null,
    public val description: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageMoverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagemover.AgentArgs> {
    override fun toJava(): com.pulumi.azurenative.storagemover.AgentArgs =
        com.pulumi.azurenative.storagemover.AgentArgs.builder()
            .agentName(agentName?.applyValue({ args0 -> args0 }))
            .arcResourceId(arcResourceId?.applyValue({ args0 -> args0 }))
            .arcVmUuid(arcVmUuid?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageMoverName(storageMoverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentArgs].
 */
@PulumiTagMarker
public class AgentArgsBuilder internal constructor() {
    private var agentName: Output<String>? = null

    private var arcResourceId: Output<String>? = null

    private var arcVmUuid: Output<String>? = null

    private var description: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageMoverName: Output<String>? = null

    /**
     * @param value The name of the Agent resource.
     */
    @JvmName("rjwytgpwxytlppta")
    public suspend fun agentName(`value`: Output<String>) {
        this.agentName = value
    }

    /**
     * @param value The fully qualified resource ID of the Hybrid Compute resource for the Agent.
     */
    @JvmName("ttrgtwbgcenftnkc")
    public suspend fun arcResourceId(`value`: Output<String>) {
        this.arcResourceId = value
    }

    /**
     * @param value The VM UUID of the Hybrid Compute resource for the Agent.
     */
    @JvmName("xhnrtibavgicspsb")
    public suspend fun arcVmUuid(`value`: Output<String>) {
        this.arcVmUuid = value
    }

    /**
     * @param value A description for the Agent.
     */
    @JvmName("dlxmcebeupjvlfdp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("atloscnpgserrgjp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Storage Mover resource.
     */
    @JvmName("obobwsoyqkhugtcb")
    public suspend fun storageMoverName(`value`: Output<String>) {
        this.storageMoverName = value
    }

    /**
     * @param value The name of the Agent resource.
     */
    @JvmName("bvvqrpmndlorrtjo")
    public suspend fun agentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentName = mapped
    }

    /**
     * @param value The fully qualified resource ID of the Hybrid Compute resource for the Agent.
     */
    @JvmName("ytjdeuoxgfxxshcu")
    public suspend fun arcResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcResourceId = mapped
    }

    /**
     * @param value The VM UUID of the Hybrid Compute resource for the Agent.
     */
    @JvmName("umuintppolqakmdt")
    public suspend fun arcVmUuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcVmUuid = mapped
    }

    /**
     * @param value A description for the Agent.
     */
    @JvmName("xecyxushrvpbgukc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tsjpuadvnbalmnkp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Storage Mover resource.
     */
    @JvmName("ajpoowxiqejrdcsw")
    public suspend fun storageMoverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageMoverName = mapped
    }

    internal fun build(): AgentArgs = AgentArgs(
        agentName = agentName,
        arcResourceId = arcResourceId,
        arcVmUuid = arcVmUuid,
        description = description,
        resourceGroupName = resourceGroupName,
        storageMoverName = storageMoverName,
    )
}
