@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin

import com.pulumi.azurenative.storagemover.ProjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Project resource.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2022-07-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-10-01.
 * ## Example Usage
 * ### Projects_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var project = new AzureNative.StorageMover.Project("project", new()
 *     {
 *         Description = "Example Project Description",
 *         ProjectName = "examples-projectName",
 *         ResourceGroupName = "examples-rg",
 *         StorageMoverName = "examples-storageMoverName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagemover/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagemover.NewProject(ctx, "project", &storagemover.ProjectArgs{
 * 			Description:       pulumi.String("Example Project Description"),
 * 			ProjectName:       pulumi.String("examples-projectName"),
 * 			ResourceGroupName: pulumi.String("examples-rg"),
 * 			StorageMoverName:  pulumi.String("examples-storageMoverName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagemover.Project;
 * import com.pulumi.azurenative.storagemover.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var project = new Project("project", ProjectArgs.builder()
 *             .description("Example Project Description")
 *             .projectName("examples-projectName")
 *             .resourceGroupName("examples-rg")
 *             .storageMoverName("examples-storageMoverName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagemover:Project examples-projectName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageMover/storageMovers/{storageMoverName}/projects/{projectName}
 * ```
 * @property description A description for the Project.
 * @property projectName The name of the Project resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageMoverName The name of the Storage Mover resource.
 */
public data class ProjectArgs(
    public val description: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageMoverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagemover.ProjectArgs> {
    override fun toJava(): com.pulumi.azurenative.storagemover.ProjectArgs =
        com.pulumi.azurenative.storagemover.ProjectArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageMoverName(storageMoverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var projectName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageMoverName: Output<String>? = null

    /**
     * @param value A description for the Project.
     */
    @JvmName("gqimoyhxpfeopjuk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the Project resource.
     */
    @JvmName("sapqgoumsfiyehui")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gapcwggmcamfuyiu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Storage Mover resource.
     */
    @JvmName("dbxwntkkqxgiauxa")
    public suspend fun storageMoverName(`value`: Output<String>) {
        this.storageMoverName = value
    }

    /**
     * @param value A description for the Project.
     */
    @JvmName("ywfaakllltcnygxx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the Project resource.
     */
    @JvmName("rahgudxkkwjwfgbx")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cmygxqiqppaamact")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Storage Mover resource.
     */
    @JvmName("wyvlpywkgyawsisp")
    public suspend fun storageMoverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageMoverName = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        description = description,
        projectName = projectName,
        resourceGroupName = resourceGroupName,
        storageMoverName = storageMoverName,
    )
}
