@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin.inputs

import com.pulumi.azurenative.storagemover.inputs.GetAgentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property agentName The name of the Agent resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageMoverName The name of the Storage Mover resource.
 */
public data class GetAgentPlainArgs(
    public val agentName: String,
    public val resourceGroupName: String,
    public val storageMoverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagemover.inputs.GetAgentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagemover.inputs.GetAgentPlainArgs =
        com.pulumi.azurenative.storagemover.inputs.GetAgentPlainArgs.builder()
            .agentName(agentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageMoverName(storageMoverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAgentPlainArgs].
 */
@PulumiTagMarker
public class GetAgentPlainArgsBuilder internal constructor() {
    private var agentName: String? = null

    private var resourceGroupName: String? = null

    private var storageMoverName: String? = null

    /**
     * @param value The name of the Agent resource.
     */
    @JvmName("rvqonqggitljfnpm")
    public suspend fun agentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.agentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fanxsosxmfmiuumj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Storage Mover resource.
     */
    @JvmName("stnlnbrdiihdqswr")
    public suspend fun storageMoverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageMoverName = mapped
    }

    internal fun build(): GetAgentPlainArgs = GetAgentPlainArgs(
        agentName = agentName ?: throw PulumiNullFieldException("agentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageMoverName = storageMoverName ?: throw PulumiNullFieldException("storageMoverName"),
    )
}
