@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin.inputs

import com.pulumi.azurenative.storagemover.inputs.GetProjectPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property projectName The name of the Project resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageMoverName The name of the Storage Mover resource.
 */
public data class GetProjectPlainArgs(
    public val projectName: String,
    public val resourceGroupName: String,
    public val storageMoverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagemover.inputs.GetProjectPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagemover.inputs.GetProjectPlainArgs =
        com.pulumi.azurenative.storagemover.inputs.GetProjectPlainArgs.builder()
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageMoverName(storageMoverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectPlainArgs].
 */
@PulumiTagMarker
public class GetProjectPlainArgsBuilder internal constructor() {
    private var projectName: String? = null

    private var resourceGroupName: String? = null

    private var storageMoverName: String? = null

    /**
     * @param value The name of the Project resource.
     */
    @JvmName("bdqnrcyvdvjbidfc")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dathefsskjuuexkl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Storage Mover resource.
     */
    @JvmName("omklaprsdtywliln")
    public suspend fun storageMoverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageMoverName = mapped
    }

    internal fun build(): GetProjectPlainArgs = GetProjectPlainArgs(
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageMoverName = storageMoverName ?: throw PulumiNullFieldException("storageMoverName"),
    )
}
