@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagepool.kotlin.inputs

import com.pulumi.azurenative.storagepool.inputs.AclArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
 * @property initiatorIqn iSCSI initiator IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:client".
 * @property mappedLuns List of LUN names mapped to the ACL.
 */
public data class AclArgs(
    public val initiatorIqn: Output<String>,
    public val mappedLuns: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.storagepool.inputs.AclArgs> {
    override fun toJava(): com.pulumi.azurenative.storagepool.inputs.AclArgs =
        com.pulumi.azurenative.storagepool.inputs.AclArgs.builder()
            .initiatorIqn(initiatorIqn.applyValue({ args0 -> args0 }))
            .mappedLuns(mappedLuns.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AclArgs].
 */
@PulumiTagMarker
public class AclArgsBuilder internal constructor() {
    private var initiatorIqn: Output<String>? = null

    private var mappedLuns: Output<List<String>>? = null

    /**
     * @param value iSCSI initiator IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:client".
     */
    @JvmName("iyrdmikcwfylbuxo")
    public suspend fun initiatorIqn(`value`: Output<String>) {
        this.initiatorIqn = value
    }

    /**
     * @param value List of LUN names mapped to the ACL.
     */
    @JvmName("csqxhtacqrhchgla")
    public suspend fun mappedLuns(`value`: Output<List<String>>) {
        this.mappedLuns = value
    }

    @JvmName("xiqrshjrvqaokjei")
    public suspend fun mappedLuns(vararg values: Output<String>) {
        this.mappedLuns = Output.all(values.asList())
    }

    /**
     * @param values List of LUN names mapped to the ACL.
     */
    @JvmName("iysjppolldcgqvhw")
    public suspend fun mappedLuns(values: List<Output<String>>) {
        this.mappedLuns = Output.all(values)
    }

    /**
     * @param value iSCSI initiator IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:client".
     */
    @JvmName("vwmqfaytplnqnjro")
    public suspend fun initiatorIqn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initiatorIqn = mapped
    }

    /**
     * @param value List of LUN names mapped to the ACL.
     */
    @JvmName("fpvwhfipelccrkva")
    public suspend fun mappedLuns(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mappedLuns = mapped
    }

    /**
     * @param values List of LUN names mapped to the ACL.
     */
    @JvmName("pdcdeyxlsxrrnfnj")
    public suspend fun mappedLuns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mappedLuns = mapped
    }

    internal fun build(): AclArgs = AclArgs(
        initiatorIqn = initiatorIqn ?: throw PulumiNullFieldException("initiatorIqn"),
        mappedLuns = mappedLuns ?: throw PulumiNullFieldException("mappedLuns"),
    )
}
