@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagepool.kotlin.inputs

import com.pulumi.azurenative.storagepool.inputs.GetIscsiTargetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property diskPoolName The name of the Disk Pool.
 * @property iscsiTargetName The name of the iSCSI Target.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetIscsiTargetPlainArgs(
    public val diskPoolName: String,
    public val iscsiTargetName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagepool.inputs.GetIscsiTargetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagepool.inputs.GetIscsiTargetPlainArgs =
        com.pulumi.azurenative.storagepool.inputs.GetIscsiTargetPlainArgs.builder()
            .diskPoolName(diskPoolName.let({ args0 -> args0 }))
            .iscsiTargetName(iscsiTargetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIscsiTargetPlainArgs].
 */
@PulumiTagMarker
public class GetIscsiTargetPlainArgsBuilder internal constructor() {
    private var diskPoolName: String? = null

    private var iscsiTargetName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Disk Pool.
     */
    @JvmName("wjmesltjrdhfgnvc")
    public suspend fun diskPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.diskPoolName = mapped
    }

    /**
     * @param value The name of the iSCSI Target.
     */
    @JvmName("biyvpiitfulklnmo")
    public suspend fun iscsiTargetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.iscsiTargetName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("toxisjobuqjnahtt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIscsiTargetPlainArgs = GetIscsiTargetPlainArgs(
        diskPoolName = diskPoolName ?: throw PulumiNullFieldException("diskPoolName"),
        iscsiTargetName = iscsiTargetName ?: throw PulumiNullFieldException("iscsiTargetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
