@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin

import com.pulumi.azurenative.storagesync.CloudEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cloud Endpoint object.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2017-06-05-preview, 2018-04-02, 2018-07-01, 2018-10-01, 2022-09-01.
 * ## Example Usage
 * ### CloudEndpoints_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudEndpoint = new AzureNative.StorageSync.CloudEndpoint("cloudEndpoint", new()
 *     {
 *         AzureFileShareName = "cvcloud-afscv-0719-058-a94a1354-a1fd-4e9a-9a50-919fad8c4ba4",
 *         CloudEndpointName = "SampleCloudEndpoint_1",
 *         FriendlyName = "ankushbsubscriptionmgmtmab",
 *         ResourceGroupName = "SampleResourceGroup_1",
 *         StorageAccountResourceId = "/subscriptions/744f4d70-6d17-4921-8970-a765d14f763f/resourceGroups/tminienv59svc/providers/Microsoft.Storage/storageAccounts/tminienv59storage",
 *         StorageAccountTenantId = "\"72f988bf-86f1-41af-91ab-2d7cd011db47\"",
 *         StorageSyncServiceName = "SampleStorageSyncService_1",
 *         SyncGroupName = "SampleSyncGroup_1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagesync/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagesync.NewCloudEndpoint(ctx, "cloudEndpoint", &storagesync.CloudEndpointArgs{
 * 			AzureFileShareName:       pulumi.String("cvcloud-afscv-0719-058-a94a1354-a1fd-4e9a-9a50-919fad8c4ba4"),
 * 			CloudEndpointName:        pulumi.String("SampleCloudEndpoint_1"),
 * 			FriendlyName:             pulumi.String("ankushbsubscriptionmgmtmab"),
 * 			ResourceGroupName:        pulumi.String("SampleResourceGroup_1"),
 * 			StorageAccountResourceId: pulumi.String("/subscriptions/744f4d70-6d17-4921-8970-a765d14f763f/resourceGroups/tminienv59svc/providers/Microsoft.Storage/storageAccounts/tminienv59storage"),
 * 			StorageAccountTenantId:   pulumi.String("\"72f988bf-86f1-41af-91ab-2d7cd011db47\""),
 * 			StorageSyncServiceName:   pulumi.String("SampleStorageSyncService_1"),
 * 			SyncGroupName:            pulumi.String("SampleSyncGroup_1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagesync.CloudEndpoint;
 * import com.pulumi.azurenative.storagesync.CloudEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudEndpoint = new CloudEndpoint("cloudEndpoint", CloudEndpointArgs.builder()
 *             .azureFileShareName("cvcloud-afscv-0719-058-a94a1354-a1fd-4e9a-9a50-919fad8c4ba4")
 *             .cloudEndpointName("SampleCloudEndpoint_1")
 *             .friendlyName("ankushbsubscriptionmgmtmab")
 *             .resourceGroupName("SampleResourceGroup_1")
 *             .storageAccountResourceId("/subscriptions/744f4d70-6d17-4921-8970-a765d14f763f/resourceGroups/tminienv59svc/providers/Microsoft.Storage/storageAccounts/tminienv59storage")
 *             .storageAccountTenantId("\"72f988bf-86f1-41af-91ab-2d7cd011db47\"")
 *             .storageSyncServiceName("SampleStorageSyncService_1")
 *             .syncGroupName("SampleSyncGroup_1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagesync:CloudEndpoint SampleCloudEndpoint_1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageSync/storageSyncServices/{storageSyncServiceName}/syncGroups/{syncGroupName}/cloudEndpoints/{cloudEndpointName}
 * ```
 * @property azureFileShareName Azure file share name
 * @property cloudEndpointName Name of Cloud Endpoint object.
 * @property friendlyName Friendly Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageAccountResourceId Storage Account Resource Id
 * @property storageAccountTenantId Storage Account Tenant Id
 * @property storageSyncServiceName Name of Storage Sync Service resource.
 * @property syncGroupName Name of Sync Group resource.
 */
public data class CloudEndpointArgs(
    public val azureFileShareName: Output<String>? = null,
    public val cloudEndpointName: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccountResourceId: Output<String>? = null,
    public val storageAccountTenantId: Output<String>? = null,
    public val storageSyncServiceName: Output<String>? = null,
    public val syncGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagesync.CloudEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.storagesync.CloudEndpointArgs =
        com.pulumi.azurenative.storagesync.CloudEndpointArgs.builder()
            .azureFileShareName(azureFileShareName?.applyValue({ args0 -> args0 }))
            .cloudEndpointName(cloudEndpointName?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccountResourceId(storageAccountResourceId?.applyValue({ args0 -> args0 }))
            .storageAccountTenantId(storageAccountTenantId?.applyValue({ args0 -> args0 }))
            .storageSyncServiceName(storageSyncServiceName?.applyValue({ args0 -> args0 }))
            .syncGroupName(syncGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CloudEndpointArgs].
 */
@PulumiTagMarker
public class CloudEndpointArgsBuilder internal constructor() {
    private var azureFileShareName: Output<String>? = null

    private var cloudEndpointName: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccountResourceId: Output<String>? = null

    private var storageAccountTenantId: Output<String>? = null

    private var storageSyncServiceName: Output<String>? = null

    private var syncGroupName: Output<String>? = null

    /**
     * @param value Azure file share name
     */
    @JvmName("ipgwbwqiyvsgxgnk")
    public suspend fun azureFileShareName(`value`: Output<String>) {
        this.azureFileShareName = value
    }

    /**
     * @param value Name of Cloud Endpoint object.
     */
    @JvmName("fmkfyfjausldtwff")
    public suspend fun cloudEndpointName(`value`: Output<String>) {
        this.cloudEndpointName = value
    }

    /**
     * @param value Friendly Name
     */
    @JvmName("buwsamyjocpmbvjq")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xikwveyirxgumewf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Storage Account Resource Id
     */
    @JvmName("ijjitdlnwtyincnb")
    public suspend fun storageAccountResourceId(`value`: Output<String>) {
        this.storageAccountResourceId = value
    }

    /**
     * @param value Storage Account Tenant Id
     */
    @JvmName("uibmjvikgaosavdw")
    public suspend fun storageAccountTenantId(`value`: Output<String>) {
        this.storageAccountTenantId = value
    }

    /**
     * @param value Name of Storage Sync Service resource.
     */
    @JvmName("eutdsjmmrndlaoup")
    public suspend fun storageSyncServiceName(`value`: Output<String>) {
        this.storageSyncServiceName = value
    }

    /**
     * @param value Name of Sync Group resource.
     */
    @JvmName("gchympeikoyxegga")
    public suspend fun syncGroupName(`value`: Output<String>) {
        this.syncGroupName = value
    }

    /**
     * @param value Azure file share name
     */
    @JvmName("mxojipnjetrxmgad")
    public suspend fun azureFileShareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFileShareName = mapped
    }

    /**
     * @param value Name of Cloud Endpoint object.
     */
    @JvmName("egqoyhxoardpovgg")
    public suspend fun cloudEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudEndpointName = mapped
    }

    /**
     * @param value Friendly Name
     */
    @JvmName("odnevumjppluhkqy")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jbqbiganwhfxlwqj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Storage Account Resource Id
     */
    @JvmName("rrditkwsgkqlioou")
    public suspend fun storageAccountResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountResourceId = mapped
    }

    /**
     * @param value Storage Account Tenant Id
     */
    @JvmName("dqnidwegaohebybw")
    public suspend fun storageAccountTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountTenantId = mapped
    }

    /**
     * @param value Name of Storage Sync Service resource.
     */
    @JvmName("wlquitklltlwhkct")
    public suspend fun storageSyncServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSyncServiceName = mapped
    }

    /**
     * @param value Name of Sync Group resource.
     */
    @JvmName("sibdevvnooisryxg")
    public suspend fun syncGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncGroupName = mapped
    }

    internal fun build(): CloudEndpointArgs = CloudEndpointArgs(
        azureFileShareName = azureFileShareName,
        cloudEndpointName = cloudEndpointName,
        friendlyName = friendlyName,
        resourceGroupName = resourceGroupName,
        storageAccountResourceId = storageAccountResourceId,
        storageAccountTenantId = storageAccountTenantId,
        storageSyncServiceName = storageSyncServiceName,
        syncGroupName = syncGroupName,
    )
}
