@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin

import com.pulumi.azurenative.storagesync.StorageSyncServiceArgs.builder
import com.pulumi.azurenative.storagesync.kotlin.enums.IncomingTrafficPolicy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Storage Sync Service object.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2017-06-05-preview, 2019-10-01, 2022-09-01.
 * ## Example Usage
 * ### StorageSyncServices_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageSyncService = new AzureNative.StorageSync.StorageSyncService("storageSyncService", new()
 *     {
 *         IncomingTrafficPolicy = "AllowAllTraffic",
 *         Location = "WestUS",
 *         ResourceGroupName = "SampleResourceGroup_1",
 *         StorageSyncServiceName = "SampleStorageSyncService_1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagesync/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagesync.NewStorageSyncService(ctx, "storageSyncService", &storagesync.StorageSyncServiceArgs{
 * 			IncomingTrafficPolicy:  pulumi.String("AllowAllTraffic"),
 * 			Location:               pulumi.String("WestUS"),
 * 			ResourceGroupName:      pulumi.String("SampleResourceGroup_1"),
 * 			StorageSyncServiceName: pulumi.String("SampleStorageSyncService_1"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagesync.StorageSyncService;
 * import com.pulumi.azurenative.storagesync.StorageSyncServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageSyncService = new StorageSyncService("storageSyncService", StorageSyncServiceArgs.builder()
 *             .incomingTrafficPolicy("AllowAllTraffic")
 *             .location("WestUS")
 *             .resourceGroupName("SampleResourceGroup_1")
 *             .storageSyncServiceName("SampleStorageSyncService_1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagesync:StorageSyncService SampleStorageSyncService_1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageSync/storageSyncServices/{storageSyncServiceName}
 * ```
 * @property incomingTrafficPolicy Incoming Traffic Policy
 * @property location Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageSyncServiceName Name of Storage Sync Service resource.
 * @property tags Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
 */
public data class StorageSyncServiceArgs(
    public val incomingTrafficPolicy: Output<Either<String, IncomingTrafficPolicy>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageSyncServiceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagesync.StorageSyncServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.storagesync.StorageSyncServiceArgs =
        com.pulumi.azurenative.storagesync.StorageSyncServiceArgs.builder()
            .incomingTrafficPolicy(
                incomingTrafficPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageSyncServiceName(storageSyncServiceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StorageSyncServiceArgs].
 */
@PulumiTagMarker
public class StorageSyncServiceArgsBuilder internal constructor() {
    private var incomingTrafficPolicy: Output<Either<String, IncomingTrafficPolicy>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageSyncServiceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Incoming Traffic Policy
     */
    @JvmName("ilnxgyfptbrvwvth")
    public suspend fun incomingTrafficPolicy(`value`: Output<Either<String, IncomingTrafficPolicy>>) {
        this.incomingTrafficPolicy = value
    }

    /**
     * @param value Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
     */
    @JvmName("hfinvtvqmvumsfrl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("swktdnblxphkmgwq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of Storage Sync Service resource.
     */
    @JvmName("oyrucgfsjmewtkke")
    public suspend fun storageSyncServiceName(`value`: Output<String>) {
        this.storageSyncServiceName = value
    }

    /**
     * @param value Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
     */
    @JvmName("uqxwxurrstbtltqk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Incoming Traffic Policy
     */
    @JvmName("vivopxxwwvlxqsrq")
    public suspend fun incomingTrafficPolicy(`value`: Either<String, IncomingTrafficPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incomingTrafficPolicy = mapped
    }

    /**
     * @param value Incoming Traffic Policy
     */
    @JvmName("wgsdxwfxkxrafpbv")
    public fun incomingTrafficPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IncomingTrafficPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.incomingTrafficPolicy = mapped
    }

    /**
     * @param value Incoming Traffic Policy
     */
    @JvmName("ddkrkrxaaoxmqawt")
    public fun incomingTrafficPolicy(`value`: IncomingTrafficPolicy) {
        val toBeMapped = Either.ofRight<String, IncomingTrafficPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.incomingTrafficPolicy = mapped
    }

    /**
     * @param value Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
     */
    @JvmName("phxjscgksksreidu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ixsnyohkginershf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Storage Sync Service resource.
     */
    @JvmName("cjmhugfjohkfjvgm")
    public suspend fun storageSyncServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSyncServiceName = mapped
    }

    /**
     * @param value Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
     */
    @JvmName("uvxmudwilxvsyoih")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
     */
    @JvmName("bgxnllqcgdonxumr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StorageSyncServiceArgs = StorageSyncServiceArgs(
        incomingTrafficPolicy = incomingTrafficPolicy,
        location = location,
        resourceGroupName = resourceGroupName,
        storageSyncServiceName = storageSyncServiceName,
        tags = tags,
    )
}
