@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.BackupPolicyArgs.builder
import com.pulumi.azurenative.storsimple.kotlin.enums.Kind
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The backup policy.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * ## Example Usage
 * ### BackupPoliciesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupPolicy = new AzureNative.StorSimple.BackupPolicy("backupPolicy", new()
 *     {
 *         BackupPolicyName = "BkUpPolicy01ForSDKTest",
 *         DeviceName = "Device05ForSDKTest",
 *         Kind = AzureNative.StorSimple.Kind.Series8000,
 *         ManagerName = "ManagerForSDKTest1",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         VolumeIds = new[]
 *         {
 *             "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest/volumes/Clonedvolume1",
 *             "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest/volumes/volume1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewBackupPolicy(ctx, "backupPolicy", &storsimple.BackupPolicyArgs{
 * 			BackupPolicyName:  pulumi.String("BkUpPolicy01ForSDKTest"),
 * 			DeviceName:        pulumi.String("Device05ForSDKTest"),
 * 			Kind:              storsimple.KindSeries8000,
 * 			ManagerName:       pulumi.String("ManagerForSDKTest1"),
 * 			ResourceGroupName: pulumi.String("ResourceGroupForSDKTest"),
 * 			VolumeIds: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest/volumes/Clonedvolume1"),
 * 				pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest/volumes/volume1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.BackupPolicy;
 * import com.pulumi.azurenative.storsimple.BackupPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupPolicy = new BackupPolicy("backupPolicy", BackupPolicyArgs.builder()
 *             .backupPolicyName("BkUpPolicy01ForSDKTest")
 *             .deviceName("Device05ForSDKTest")
 *             .kind("Series8000")
 *             .managerName("ManagerForSDKTest1")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .volumeIds(
 *                 "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest/volumes/Clonedvolume1",
 *                 "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest/volumes/volume1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:BackupPolicy BkUpPolicy01ForSDKTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupPolicies/{backupPolicyName}
 * ```
 * @property backupPolicyName The name of the backup policy to be created/updated.
 * @property deviceName The device name
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 * @property volumeIds The path IDs of the volumes which are part of the backup policy.
 */
public data class BackupPolicyArgs(
    public val backupPolicyName: Output<String>? = null,
    public val deviceName: Output<String>? = null,
    public val kind: Output<Kind>? = null,
    public val managerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val volumeIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.BackupPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.BackupPolicyArgs =
        com.pulumi.azurenative.storsimple.BackupPolicyArgs.builder()
            .backupPolicyName(backupPolicyName?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managerName(managerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .volumeIds(volumeIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BackupPolicyArgs].
 */
@PulumiTagMarker
public class BackupPolicyArgsBuilder internal constructor() {
    private var backupPolicyName: Output<String>? = null

    private var deviceName: Output<String>? = null

    private var kind: Output<Kind>? = null

    private var managerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var volumeIds: Output<List<String>>? = null

    /**
     * @param value The name of the backup policy to be created/updated.
     */
    @JvmName("yovvyowupgaxgana")
    public suspend fun backupPolicyName(`value`: Output<String>) {
        this.backupPolicyName = value
    }

    /**
     * @param value The device name
     */
    @JvmName("mtynjfjbrhtnwiak")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("owgoyjnvpoqcoaii")
    public suspend fun kind(`value`: Output<Kind>) {
        this.kind = value
    }

    /**
     * @param value The manager name
     */
    @JvmName("rhxhhxbixxdplnwq")
    public suspend fun managerName(`value`: Output<String>) {
        this.managerName = value
    }

    /**
     * @param value The resource group name
     */
    @JvmName("yhxmhpltmagdaqrx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The path IDs of the volumes which are part of the backup policy.
     */
    @JvmName("aqquyodcjkbwtcgo")
    public suspend fun volumeIds(`value`: Output<List<String>>) {
        this.volumeIds = value
    }

    @JvmName("sebnojhtqeqgmxyi")
    public suspend fun volumeIds(vararg values: Output<String>) {
        this.volumeIds = Output.all(values.asList())
    }

    /**
     * @param values The path IDs of the volumes which are part of the backup policy.
     */
    @JvmName("wgugvlcrplohkuae")
    public suspend fun volumeIds(values: List<Output<String>>) {
        this.volumeIds = Output.all(values)
    }

    /**
     * @param value The name of the backup policy to be created/updated.
     */
    @JvmName("vvotqdpupausmbsh")
    public suspend fun backupPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPolicyName = mapped
    }

    /**
     * @param value The device name
     */
    @JvmName("cixpwssebwgbewxh")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("jdrpdflyawwecwmk")
    public suspend fun kind(`value`: Kind?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("ydvtevdoqfskhtyk")
    public suspend fun managerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("xvfqwdphqvjytsyx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The path IDs of the volumes which are part of the backup policy.
     */
    @JvmName("lxckvfwygevnxmdp")
    public suspend fun volumeIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeIds = mapped
    }

    /**
     * @param values The path IDs of the volumes which are part of the backup policy.
     */
    @JvmName("gxmqmgvpihsgjynk")
    public suspend fun volumeIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeIds = mapped
    }

    internal fun build(): BackupPolicyArgs = BackupPolicyArgs(
        backupPolicyName = backupPolicyName,
        deviceName = deviceName,
        kind = kind,
        managerName = managerName,
        resourceGroupName = resourceGroupName,
        volumeIds = volumeIds,
    )
}
