@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.kotlin.outputs.ScheduleRecurrenceResponse
import com.pulumi.azurenative.storsimple.kotlin.outputs.ScheduleRecurrenceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BackupSchedule].
 */
@PulumiTagMarker
public class BackupScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupScheduleArgs = BackupScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupScheduleArgsBuilder.() -> Unit) {
        val builder = BackupScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BackupSchedule {
        val builtJavaResource =
            com.pulumi.azurenative.storsimple.BackupSchedule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BackupSchedule(builtJavaResource)
    }
}

/**
 * The backup schedule.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * ## Example Usage
 * ### BackupSchedulesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupSchedule = new AzureNative.StorSimple.BackupSchedule("backupSchedule", new()
 *     {
 *         BackupPolicyName = "BkUpPolicy01ForSDKTest",
 *         BackupScheduleName = "schedule2",
 *         BackupType = AzureNative.StorSimple.BackupType.CloudSnapshot,
 *         DeviceName = "Device05ForSDKTest",
 *         Kind = AzureNative.StorSimple.Kind.Series8000,
 *         ManagerName = "ManagerForSDKTest1",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         RetentionCount = 1,
 *         ScheduleRecurrence = new AzureNative.StorSimple.Inputs.ScheduleRecurrenceArgs
 *         {
 *             RecurrenceType = AzureNative.StorSimple.RecurrenceType.Weekly,
 *             RecurrenceValue = 1,
 *             WeeklyDaysList = new[]
 *             {
 *                 AzureNative.StorSimple.DayOfWeek.Friday,
 *                 AzureNative.StorSimple.DayOfWeek.Thursday,
 *                 AzureNative.StorSimple.DayOfWeek.Monday,
 *             },
 *         },
 *         ScheduleStatus = AzureNative.StorSimple.ScheduleStatus.Enabled,
 *         StartTime = "2017-06-24T01:00:00Z",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewBackupSchedule(ctx, "backupSchedule", &storsimple.BackupScheduleArgs{
 * 			BackupPolicyName:   pulumi.String("BkUpPolicy01ForSDKTest"),
 * 			BackupScheduleName: pulumi.String("schedule2"),
 * 			BackupType:         storsimple.BackupTypeCloudSnapshot,
 * 			DeviceName:         pulumi.String("Device05ForSDKTest"),
 * 			Kind:               storsimple.KindSeries8000,
 * 			ManagerName:        pulumi.String("ManagerForSDKTest1"),
 * 			ResourceGroupName:  pulumi.String("ResourceGroupForSDKTest"),
 * 			RetentionCount:     pulumi.Float64(1),
 * 			ScheduleRecurrence: &storsimple.ScheduleRecurrenceArgs{
 * 				RecurrenceType:  storsimple.RecurrenceTypeWeekly,
 * 				RecurrenceValue: pulumi.Int(1),
 * 				WeeklyDaysList: storsimple.DayOfWeekArray{
 * 					storsimple.DayOfWeekFriday,
 * 					storsimple.DayOfWeekThursday,
 * 					storsimple.DayOfWeekMonday,
 * 				},
 * 			},
 * 			ScheduleStatus: storsimple.ScheduleStatusEnabled,
 * 			StartTime:      pulumi.String("2017-06-24T01:00:00Z"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.BackupSchedule;
 * import com.pulumi.azurenative.storsimple.BackupScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupSchedule = new BackupSchedule("backupSchedule", BackupScheduleArgs.builder()
 *             .backupPolicyName("BkUpPolicy01ForSDKTest")
 *             .backupScheduleName("schedule2")
 *             .backupType("CloudSnapshot")
 *             .deviceName("Device05ForSDKTest")
 *             .kind("Series8000")
 *             .managerName("ManagerForSDKTest1")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .retentionCount(1)
 *             .scheduleRecurrence(Map.ofEntries(
 *                 Map.entry("recurrenceType", "Weekly"),
 *                 Map.entry("recurrenceValue", 1),
 *                 Map.entry("weeklyDaysList",
 *                     "Friday",
 *                     "Thursday",
 *                     "Monday")
 *             ))
 *             .scheduleStatus("Enabled")
 *             .startTime("2017-06-24T01:00:00Z")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:BackupSchedule schedule2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupPolicies/{backupPolicyName}/schedules/{backupScheduleName}
 * ```
 */
public class BackupSchedule internal constructor(
    override val javaResource: com.pulumi.azurenative.storsimple.BackupSchedule,
) : KotlinCustomResource(javaResource, BackupScheduleMapper) {
    /**
     * The type of backup which needs to be taken.
     */
    public val backupType: Output<String>
        get() = javaResource.backupType().applyValue({ args0 -> args0 })

    /**
     * The Kind of the object. Currently only Series8000 is supported
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The last successful backup run which was triggered for the schedule.
     */
    public val lastSuccessfulRun: Output<String>
        get() = javaResource.lastSuccessfulRun().applyValue({ args0 -> args0 })

    /**
     * The name of the object.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The number of backups to be retained.
     */
    public val retentionCount: Output<Double>
        get() = javaResource.retentionCount().applyValue({ args0 -> args0 })

    /**
     * The schedule recurrence.
     */
    public val scheduleRecurrence: Output<ScheduleRecurrenceResponse>
        get() = javaResource.scheduleRecurrence().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The schedule status.
     */
    public val scheduleStatus: Output<String>
        get() = javaResource.scheduleStatus().applyValue({ args0 -> args0 })

    /**
     * The start time of the schedule.
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BackupScheduleMapper : ResourceMapper<BackupSchedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storsimple.BackupSchedule::class == javaResource::class

    override fun map(javaResource: Resource): BackupSchedule = BackupSchedule(
        javaResource as
            com.pulumi.azurenative.storsimple.BackupSchedule,
    )
}

/**
 * @see [BackupSchedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackupSchedule].
 */
public suspend fun backupSchedule(
    name: String,
    block: suspend BackupScheduleResourceBuilder.() -> Unit,
): BackupSchedule {
    val builder = BackupScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackupSchedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backupSchedule(name: String): BackupSchedule {
    val builder = BackupScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
