@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.kotlin.outputs.AsymmetricEncryptedSecretResponse
import com.pulumi.azurenative.storsimple.kotlin.outputs.AsymmetricEncryptedSecretResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StorageAccountCredential].
 */
@PulumiTagMarker
public class StorageAccountCredentialResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageAccountCredentialArgs = StorageAccountCredentialArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageAccountCredentialArgsBuilder.() -> Unit) {
        val builder = StorageAccountCredentialArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StorageAccountCredential {
        val builtJavaResource =
            com.pulumi.azurenative.storsimple.StorageAccountCredential(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageAccountCredential(builtJavaResource)
    }
}

/**
 * The storage account credential.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * Other available API versions: 2016-10-01.
 * ## Example Usage
 * ### StorageAccountCredentialsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccountCredential = new AzureNative.StorSimple.StorageAccountCredential("storageAccountCredential", new()
 *     {
 *         AccessKey = new AzureNative.StorSimple.Inputs.AsymmetricEncryptedSecretArgs
 *         {
 *             EncryptionAlgorithm = AzureNative.StorSimple.EncryptionAlgorithm.RSAES_PKCS1_v_1_5,
 *             EncryptionCertThumbprint = "A872A2DF196AC7682EE24791E7DE2E2A360F5926",
 *             Value = "ATuJSkmrFk4h8r1jrZ4nd3nthLSddcguEO5QLO/NECUtTuB9kL4dNv3/jC4WOvFkeVr3x1UvfhlIeMmJBF1SMr6hR1JzD0xNU/TtQqUeXN7V3jk7I+2l67P9StuHWR6OMd3XOLwvznxOEQtEWpweDiobZU1ZiY03WafcGZFpV5j6tEoHeopoZ1J/GhPtkYmx+TqxzUN6qnir5rP3NSYiZciImP/qu8U9yUV/xpVRv39KvFc2Yr5SpKpMMRUj55XW10UnPer63M6KovF8X9Wi/fNnrZAs1Esl5XddZETGrW/e5B++VMJ6w0Q/uvPR+UBwrOU0804l0SzwdIe3qVVd0Q==",
 *         },
 *         EndPoint = "blob.core.windows.net",
 *         ManagerName = "ManagerForSDKTest1",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         SslStatus = AzureNative.StorSimple.SslStatus.Enabled,
 *         StorageAccountCredentialName = "SACForTest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewStorageAccountCredential(ctx, "storageAccountCredential", &storsimple.StorageAccountCredentialArgs{
 * 			AccessKey: &storsimple.AsymmetricEncryptedSecretArgs{
 * 				EncryptionAlgorithm:      storsimple.EncryptionAlgorithm_RSAES_PKCS1_v_1_5,
 * 				EncryptionCertThumbprint: pulumi.String("A872A2DF196AC7682EE24791E7DE2E2A360F5926"),
 * 				Value:                    pulumi.String("ATuJSkmrFk4h8r1jrZ4nd3nthLSddcguEO5QLO/NECUtTuB9kL4dNv3/jC4WOvFkeVr3x1UvfhlIeMmJBF1SMr6hR1JzD0xNU/TtQqUeXN7V3jk7I+2l67P9StuHWR6OMd3XOLwvznxOEQtEWpweDiobZU1ZiY03WafcGZFpV5j6tEoHeopoZ1J/GhPtkYmx+TqxzUN6qnir5rP3NSYiZciImP/qu8U9yUV/xpVRv39KvFc2Yr5SpKpMMRUj55XW10UnPer63M6KovF8X9Wi/fNnrZAs1Esl5XddZETGrW/e5B++VMJ6w0Q/uvPR+UBwrOU0804l0SzwdIe3qVVd0Q=="),
 * 			},
 * 			EndPoint:                     pulumi.String("blob.core.windows.net"),
 * 			ManagerName:                  pulumi.String("ManagerForSDKTest1"),
 * 			ResourceGroupName:            pulumi.String("ResourceGroupForSDKTest"),
 * 			SslStatus:                    storsimple.SslStatusEnabled,
 * 			StorageAccountCredentialName: pulumi.String("SACForTest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.StorageAccountCredential;
 * import com.pulumi.azurenative.storsimple.StorageAccountCredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccountCredential = new StorageAccountCredential("storageAccountCredential", StorageAccountCredentialArgs.builder()
 *             .accessKey(Map.ofEntries(
 *                 Map.entry("encryptionAlgorithm", "RSAES_PKCS1_v_1_5"),
 *                 Map.entry("encryptionCertThumbprint", "A872A2DF196AC7682EE24791E7DE2E2A360F5926"),
 *                 Map.entry("value", "ATuJSkmrFk4h8r1jrZ4nd3nthLSddcguEO5QLO/NECUtTuB9kL4dNv3/jC4WOvFkeVr3x1UvfhlIeMmJBF1SMr6hR1JzD0xNU/TtQqUeXN7V3jk7I+2l67P9StuHWR6OMd3XOLwvznxOEQtEWpweDiobZU1ZiY03WafcGZFpV5j6tEoHeopoZ1J/GhPtkYmx+TqxzUN6qnir5rP3NSYiZciImP/qu8U9yUV/xpVRv39KvFc2Yr5SpKpMMRUj55XW10UnPer63M6KovF8X9Wi/fNnrZAs1Esl5XddZETGrW/e5B++VMJ6w0Q/uvPR+UBwrOU0804l0SzwdIe3qVVd0Q==")
 *             ))
 *             .endPoint("blob.core.windows.net")
 *             .managerName("ManagerForSDKTest1")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .sslStatus("Enabled")
 *             .storageAccountCredentialName("SACForTest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:StorageAccountCredential SACForTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/storageAccountCredentials/{storageAccountCredentialName}
 * ```
 */
public class StorageAccountCredential internal constructor(
    override val javaResource: com.pulumi.azurenative.storsimple.StorageAccountCredential,
) : KotlinCustomResource(javaResource, StorageAccountCredentialMapper) {
    /**
     * The details of the storage account password.
     */
    public val accessKey: Output<AsymmetricEncryptedSecretResponse>?
        get() = javaResource.accessKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The storage endpoint
     */
    public val endPoint: Output<String>
        get() = javaResource.endPoint().applyValue({ args0 -> args0 })

    /**
     * The Kind of the object. Currently only Series8000 is supported
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the object.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Signifies whether SSL needs to be enabled or not.
     */
    public val sslStatus: Output<String>
        get() = javaResource.sslStatus().applyValue({ args0 -> args0 })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The count of volumes using this storage account credential.
     */
    public val volumesCount: Output<Int>
        get() = javaResource.volumesCount().applyValue({ args0 -> args0 })
}

public object StorageAccountCredentialMapper : ResourceMapper<StorageAccountCredential> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storsimple.StorageAccountCredential::class == javaResource::class

    override fun map(javaResource: Resource): StorageAccountCredential =
        StorageAccountCredential(
            javaResource as
                com.pulumi.azurenative.storsimple.StorageAccountCredential,
        )
}

/**
 * @see [StorageAccountCredential].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageAccountCredential].
 */
public suspend fun storageAccountCredential(
    name: String,
    block: suspend StorageAccountCredentialResourceBuilder.() -> Unit,
): StorageAccountCredential {
    val builder = StorageAccountCredentialResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageAccountCredential].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageAccountCredential(name: String): StorageAccountCredential {
    val builder = StorageAccountCredentialResourceBuilder()
    builder.name(name)
    return builder.build()
}
