@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Volume].
 */
@PulumiTagMarker
public class VolumeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VolumeArgs = VolumeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VolumeArgsBuilder.() -> Unit) {
        val builder = VolumeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Volume {
        val builtJavaResource = com.pulumi.azurenative.storsimple.Volume(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Volume(builtJavaResource)
    }
}

/**
 * The volume.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * ## Example Usage
 * ### VolumesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volume = new AzureNative.StorSimple.Volume("volume", new()
 *     {
 *         AccessControlRecordIds = new[]
 *         {
 *             "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2",
 *         },
 *         DeviceName = "Device05ForSDKTest",
 *         ManagerName = "ManagerForSDKTest1",
 *         MonitoringStatus = AzureNative.StorSimple.MonitoringStatus.Enabled,
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         SizeInBytes = 5368709120,
 *         VolumeContainerName = "VolumeContainerForSDKTest",
 *         VolumeName = "Volume1ForSDKTest",
 *         VolumeStatus = AzureNative.StorSimple.VolumeStatus.Offline,
 *         VolumeType = AzureNative.StorSimple.VolumeType.Tiered,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewVolume(ctx, "volume", &storsimple.VolumeArgs{
 * 			AccessControlRecordIds: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2"),
 * 			},
 * 			DeviceName:          pulumi.String("Device05ForSDKTest"),
 * 			ManagerName:         pulumi.String("ManagerForSDKTest1"),
 * 			MonitoringStatus:    storsimple.MonitoringStatusEnabled,
 * 			ResourceGroupName:   pulumi.String("ResourceGroupForSDKTest"),
 * 			SizeInBytes:         pulumi.Float64(5368709120),
 * 			VolumeContainerName: pulumi.String("VolumeContainerForSDKTest"),
 * 			VolumeName:          pulumi.String("Volume1ForSDKTest"),
 * 			VolumeStatus:        storsimple.VolumeStatusOffline,
 * 			VolumeType:          storsimple.VolumeTypeTiered,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.Volume;
 * import com.pulumi.azurenative.storsimple.VolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volume = new Volume("volume", VolumeArgs.builder()
 *             .accessControlRecordIds("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2")
 *             .deviceName("Device05ForSDKTest")
 *             .managerName("ManagerForSDKTest1")
 *             .monitoringStatus("Enabled")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .sizeInBytes(5368709120)
 *             .volumeContainerName("VolumeContainerForSDKTest")
 *             .volumeName("Volume1ForSDKTest")
 *             .volumeStatus("Offline")
 *             .volumeType("Tiered")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:Volume Volume1ForSDKTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/volumes/{volumeName}
 * ```
 */
public class Volume internal constructor(
    override val javaResource: com.pulumi.azurenative.storsimple.Volume,
) : KotlinCustomResource(javaResource, VolumeMapper) {
    /**
     * The IDs of the access control records, associated with the volume.
     */
    public val accessControlRecordIds: Output<List<String>>
        get() = javaResource.accessControlRecordIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The IDs of the backup policies, in which this volume is part of.
     */
    public val backupPolicyIds: Output<List<String>>
        get() = javaResource.backupPolicyIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The backup status of the volume.
     */
    public val backupStatus: Output<String>
        get() = javaResource.backupStatus().applyValue({ args0 -> args0 })

    /**
     * The Kind of the object. Currently only Series8000 is supported
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The monitoring status of the volume.
     */
    public val monitoringStatus: Output<String>
        get() = javaResource.monitoringStatus().applyValue({ args0 -> args0 })

    /**
     * The name of the object.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The operation status on the volume.
     */
    public val operationStatus: Output<String>
        get() = javaResource.operationStatus().applyValue({ args0 -> args0 })

    /**
     * The size of the volume in bytes.
     */
    public val sizeInBytes: Output<Double>
        get() = javaResource.sizeInBytes().applyValue({ args0 -> args0 })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The ID of the volume container, in which this volume is created.
     */
    public val volumeContainerId: Output<String>
        get() = javaResource.volumeContainerId().applyValue({ args0 -> args0 })

    /**
     * The volume status.
     */
    public val volumeStatus: Output<String>
        get() = javaResource.volumeStatus().applyValue({ args0 -> args0 })

    /**
     * The type of the volume.
     */
    public val volumeType: Output<String>
        get() = javaResource.volumeType().applyValue({ args0 -> args0 })
}

public object VolumeMapper : ResourceMapper<Volume> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storsimple.Volume::class == javaResource::class

    override fun map(javaResource: Resource): Volume = Volume(
        javaResource as
            com.pulumi.azurenative.storsimple.Volume,
    )
}

/**
 * @see [Volume].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Volume].
 */
public suspend fun volume(name: String, block: suspend VolumeResourceBuilder.() -> Unit): Volume {
    val builder = VolumeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Volume].
 * @param name The _unique_ name of the resulting resource.
 */
public fun volume(name: String): Volume {
    val builder = VolumeResourceBuilder()
    builder.name(name)
    return builder.build()
}
