@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.BandwidthScheduleArgs.builder
import com.pulumi.azurenative.storsimple.kotlin.enums.DayOfWeek
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The schedule for bandwidth setting.
 * @property days The days of the week when this schedule is applicable.
 * @property rateInMbps The rate in Mbps.
 * @property start The start time of the schedule.
 * @property stop The stop time of the schedule.
 */
public data class BandwidthScheduleArgs(
    public val days: Output<List<DayOfWeek>>,
    public val rateInMbps: Output<Int>,
    public val start: Output<TimeArgs>,
    public val stop: Output<TimeArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.BandwidthScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.BandwidthScheduleArgs =
        com.pulumi.azurenative.storsimple.inputs.BandwidthScheduleArgs.builder()
            .days(days.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .rateInMbps(rateInMbps.applyValue({ args0 -> args0 }))
            .start(start.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stop(stop.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BandwidthScheduleArgs].
 */
@PulumiTagMarker
public class BandwidthScheduleArgsBuilder internal constructor() {
    private var days: Output<List<DayOfWeek>>? = null

    private var rateInMbps: Output<Int>? = null

    private var start: Output<TimeArgs>? = null

    private var stop: Output<TimeArgs>? = null

    /**
     * @param value The days of the week when this schedule is applicable.
     */
    @JvmName("vgkpwidxrtgiepnw")
    public suspend fun days(`value`: Output<List<DayOfWeek>>) {
        this.days = value
    }

    @JvmName("eemcgnujggpoeowh")
    public suspend fun days(vararg values: Output<DayOfWeek>) {
        this.days = Output.all(values.asList())
    }

    /**
     * @param values The days of the week when this schedule is applicable.
     */
    @JvmName("gcqesglwmbiqrrbv")
    public suspend fun days(values: List<Output<DayOfWeek>>) {
        this.days = Output.all(values)
    }

    /**
     * @param value The rate in Mbps.
     */
    @JvmName("osxhdlsynjswftjm")
    public suspend fun rateInMbps(`value`: Output<Int>) {
        this.rateInMbps = value
    }

    /**
     * @param value The start time of the schedule.
     */
    @JvmName("bnotgmywjjkirile")
    public suspend fun start(`value`: Output<TimeArgs>) {
        this.start = value
    }

    /**
     * @param value The stop time of the schedule.
     */
    @JvmName("tdukwsfawxsycegm")
    public suspend fun stop(`value`: Output<TimeArgs>) {
        this.stop = value
    }

    /**
     * @param value The days of the week when this schedule is applicable.
     */
    @JvmName("ogeicaibuuukkyur")
    public suspend fun days(`value`: List<DayOfWeek>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param values The days of the week when this schedule is applicable.
     */
    @JvmName("ilkvueyudbpejoqw")
    public suspend fun days(vararg values: DayOfWeek) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value The rate in Mbps.
     */
    @JvmName("eksebyvuriaclwas")
    public suspend fun rateInMbps(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rateInMbps = mapped
    }

    /**
     * @param value The start time of the schedule.
     */
    @JvmName("dqcffqylvlyborhu")
    public suspend fun start(`value`: TimeArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.start = mapped
    }

    /**
     * @param argument The start time of the schedule.
     */
    @JvmName("yhbbjdcstflxipwf")
    public suspend fun start(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.start = mapped
    }

    /**
     * @param value The stop time of the schedule.
     */
    @JvmName("vrefakxfwhuqdxqi")
    public suspend fun stop(`value`: TimeArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stop = mapped
    }

    /**
     * @param argument The stop time of the schedule.
     */
    @JvmName("rohefdqoodeeuvxa")
    public suspend fun stop(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.stop = mapped
    }

    internal fun build(): BandwidthScheduleArgs = BandwidthScheduleArgs(
        days = days ?: throw PulumiNullFieldException("days"),
        rateInMbps = rateInMbps ?: throw PulumiNullFieldException("rateInMbps"),
        start = start ?: throw PulumiNullFieldException("start"),
        stop = stop ?: throw PulumiNullFieldException("stop"),
    )
}
