@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.GetBandwidthSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bandwidthSettingName The name of bandwidth setting to be fetched.
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 */
public data class GetBandwidthSettingPlainArgs(
    public val bandwidthSettingName: String,
    public val managerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.GetBandwidthSettingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.GetBandwidthSettingPlainArgs =
        com.pulumi.azurenative.storsimple.inputs.GetBandwidthSettingPlainArgs.builder()
            .bandwidthSettingName(bandwidthSettingName.let({ args0 -> args0 }))
            .managerName(managerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBandwidthSettingPlainArgs].
 */
@PulumiTagMarker
public class GetBandwidthSettingPlainArgsBuilder internal constructor() {
    private var bandwidthSettingName: String? = null

    private var managerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of bandwidth setting to be fetched.
     */
    @JvmName("upscxapepsuxvjxy")
    public suspend fun bandwidthSettingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bandwidthSettingName = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("gviosasvuoqbbsbi")
    public suspend fun managerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("fmvvrcmpqvbfovhr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBandwidthSettingPlainArgs = GetBandwidthSettingPlainArgs(
        bandwidthSettingName = bandwidthSettingName ?: throw
            PulumiNullFieldException("bandwidthSettingName"),
        managerName = managerName ?: throw PulumiNullFieldException("managerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
