@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.GetVolumeContainerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName The device name
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 * @property volumeContainerName The name of the volume container.
 */
public data class GetVolumeContainerPlainArgs(
    public val deviceName: String,
    public val managerName: String,
    public val resourceGroupName: String,
    public val volumeContainerName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.GetVolumeContainerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.GetVolumeContainerPlainArgs =
        com.pulumi.azurenative.storsimple.inputs.GetVolumeContainerPlainArgs.builder()
            .deviceName(deviceName.let({ args0 -> args0 }))
            .managerName(managerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .volumeContainerName(volumeContainerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVolumeContainerPlainArgs].
 */
@PulumiTagMarker
public class GetVolumeContainerPlainArgsBuilder internal constructor() {
    private var deviceName: String? = null

    private var managerName: String? = null

    private var resourceGroupName: String? = null

    private var volumeContainerName: String? = null

    /**
     * @param value The device name
     */
    @JvmName("mladsxivcwucgwph")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("webcwscdtocuilld")
    public suspend fun managerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("twqwccjndfnbjtqf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the volume container.
     */
    @JvmName("fbcqpokjcrvdssdd")
    public suspend fun volumeContainerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeContainerName = mapped
    }

    internal fun build(): GetVolumeContainerPlainArgs = GetVolumeContainerPlainArgs(
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        managerName = managerName ?: throw PulumiNullFieldException("managerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        volumeContainerName = volumeContainerName ?: throw PulumiNullFieldException("volumeContainerName"),
    )
}
