@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.GetVolumePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName The device name
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 * @property volumeContainerName The volume container name.
 * @property volumeName The volume name.
 */
public data class GetVolumePlainArgs(
    public val deviceName: String,
    public val managerName: String,
    public val resourceGroupName: String,
    public val volumeContainerName: String,
    public val volumeName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.GetVolumePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.GetVolumePlainArgs =
        com.pulumi.azurenative.storsimple.inputs.GetVolumePlainArgs.builder()
            .deviceName(deviceName.let({ args0 -> args0 }))
            .managerName(managerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .volumeContainerName(volumeContainerName.let({ args0 -> args0 }))
            .volumeName(volumeName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVolumePlainArgs].
 */
@PulumiTagMarker
public class GetVolumePlainArgsBuilder internal constructor() {
    private var deviceName: String? = null

    private var managerName: String? = null

    private var resourceGroupName: String? = null

    private var volumeContainerName: String? = null

    private var volumeName: String? = null

    /**
     * @param value The device name
     */
    @JvmName("jdxkctclokyoabsc")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("dhaqeuiibdxcbcsc")
    public suspend fun managerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("umeioskepewauava")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The volume container name.
     */
    @JvmName("ynqcucxhjfooomyn")
    public suspend fun volumeContainerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeContainerName = mapped
    }

    /**
     * @param value The volume name.
     */
    @JvmName("wsvteluoargbleit")
    public suspend fun volumeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeName = mapped
    }

    internal fun build(): GetVolumePlainArgs = GetVolumePlainArgs(
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        managerName = managerName ?: throw PulumiNullFieldException("managerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        volumeContainerName = volumeContainerName ?: throw PulumiNullFieldException("volumeContainerName"),
        volumeName = volumeName ?: throw PulumiNullFieldException("volumeName"),
    )
}
