@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.TimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The time.
 * @property hours The hour.
 * @property minutes The minute.
 * @property seconds The second.
 */
public data class TimeArgs(
    public val hours: Output<Int>,
    public val minutes: Output<Int>,
    public val seconds: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.TimeArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.TimeArgs =
        com.pulumi.azurenative.storsimple.inputs.TimeArgs.builder()
            .hours(hours.applyValue({ args0 -> args0 }))
            .minutes(minutes.applyValue({ args0 -> args0 }))
            .seconds(seconds.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TimeArgs].
 */
@PulumiTagMarker
public class TimeArgsBuilder internal constructor() {
    private var hours: Output<Int>? = null

    private var minutes: Output<Int>? = null

    private var seconds: Output<Int>? = null

    /**
     * @param value The hour.
     */
    @JvmName("qkjuxsxybxitwkxc")
    public suspend fun hours(`value`: Output<Int>) {
        this.hours = value
    }

    /**
     * @param value The minute.
     */
    @JvmName("oiafvaqpejrvdrxo")
    public suspend fun minutes(`value`: Output<Int>) {
        this.minutes = value
    }

    /**
     * @param value The second.
     */
    @JvmName("mgmqywkycitwimqk")
    public suspend fun seconds(`value`: Output<Int>) {
        this.seconds = value
    }

    /**
     * @param value The hour.
     */
    @JvmName("wxyynijqfeqdyxst")
    public suspend fun hours(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hours = mapped
    }

    /**
     * @param value The minute.
     */
    @JvmName("kwqadjchercclaum")
    public suspend fun minutes(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minutes = mapped
    }

    /**
     * @param value The second.
     */
    @JvmName("sfyrtfulymdywgqy")
    public suspend fun seconds(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.seconds = mapped
    }

    internal fun build(): TimeArgs = TimeArgs(
        hours = hours ?: throw PulumiNullFieldException("hours"),
        minutes = minutes ?: throw PulumiNullFieldException("minutes"),
        seconds = seconds ?: throw PulumiNullFieldException("seconds"),
    )
}
