@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represent the secrets intended for encryption with asymmetric key pair.
 * @property encryptionAlgorithm The algorithm used to encrypt "Value".
 * @property encryptionCertThumbprint Thumbprint certificate that was used to encrypt "Value". If the value in unencrypted, it will be null.
 * @property value The value of the secret.
 */
public data class AsymmetricEncryptedSecretResponse(
    public val encryptionAlgorithm: String,
    public val encryptionCertThumbprint: String? = null,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.AsymmetricEncryptedSecretResponse):
            AsymmetricEncryptedSecretResponse = AsymmetricEncryptedSecretResponse(
            encryptionAlgorithm = javaType.encryptionAlgorithm(),
            encryptionCertThumbprint = javaType.encryptionCertThumbprint().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`(),
        )
    }
}
