@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Represents the eligibility of a device as a failover target device.
 * @property availableLocalStorageInBytes The amount of free local storage available on the device in bytes.
 * @property availableTieredStorageInBytes The amount of free tiered storage available for the device in bytes.
 * @property dataContainersCount The count of data containers on the device.
 * @property deviceId The path ID of the device.
 * @property deviceLocation The geo location (applicable only for cloud appliances) of the device.
 * @property deviceSoftwareVersion The software version of the device.
 * @property deviceStatus The status of the device.
 * @property eligibilityResult The eligibility result of the device, as a failover target device.
 * @property friendlyDeviceSoftwareVersion The friendly name for the current version of software on the device.
 * @property modelDescription The model number of the device.
 * @property volumesCount The count of volumes on the device.
 */
public data class FailoverTargetResponse(
    public val availableLocalStorageInBytes: Double? = null,
    public val availableTieredStorageInBytes: Double? = null,
    public val dataContainersCount: Int? = null,
    public val deviceId: String? = null,
    public val deviceLocation: String? = null,
    public val deviceSoftwareVersion: String? = null,
    public val deviceStatus: String? = null,
    public val eligibilityResult: TargetEligibilityResultResponse? = null,
    public val friendlyDeviceSoftwareVersion: String? = null,
    public val modelDescription: String? = null,
    public val volumesCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.FailoverTargetResponse):
            FailoverTargetResponse = FailoverTargetResponse(
            availableLocalStorageInBytes = javaType.availableLocalStorageInBytes().map({ args0 ->
                args0
            }).orElse(null),
            availableTieredStorageInBytes = javaType.availableTieredStorageInBytes().map({ args0 ->
                args0
            }).orElse(null),
            dataContainersCount = javaType.dataContainersCount().map({ args0 -> args0 }).orElse(null),
            deviceId = javaType.deviceId().map({ args0 -> args0 }).orElse(null),
            deviceLocation = javaType.deviceLocation().map({ args0 -> args0 }).orElse(null),
            deviceSoftwareVersion = javaType.deviceSoftwareVersion().map({ args0 -> args0 }).orElse(null),
            deviceStatus = javaType.deviceStatus().map({ args0 -> args0 }).orElse(null),
            eligibilityResult = javaType.eligibilityResult().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storsimple.kotlin.outputs.TargetEligibilityResultResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            friendlyDeviceSoftwareVersion = javaType.friendlyDeviceSoftwareVersion().map({ args0 ->
                args0
            }).orElse(null),
            modelDescription = javaType.modelDescription().map({ args0 -> args0 }).orElse(null),
            volumesCount = javaType.volumesCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
