@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The bandwidth setting.
 * @property id The path ID that uniquely identifies the object.
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property name The name of the object.
 * @property schedules The schedules.
 * @property type The hierarchical type of the object.
 * @property volumeCount The number of volumes that uses the bandwidth setting.
 */
public data class GetBandwidthSettingResult(
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val schedules: List<BandwidthScheduleResponse>,
    public val type: String,
    public val volumeCount: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.GetBandwidthSettingResult):
            GetBandwidthSettingResult = GetBandwidthSettingResult(
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            schedules = javaType.schedules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storsimple.kotlin.outputs.BandwidthScheduleResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            volumeCount = javaType.volumeCount(),
        )
    }
}
