@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The volume container.
 * @property bandWidthRateInMbps The bandwidth-rate set on the volume container.
 * @property bandwidthSettingId The ID of the bandwidth setting associated with the volume container.
 * @property encryptionKey The key used to encrypt data in the volume container. It is required when property 'EncryptionStatus' is "Enabled".
 * @property encryptionStatus The flag to denote whether encryption is enabled or not.
 * @property id The path ID that uniquely identifies the object.
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property name The name of the object.
 * @property ownerShipStatus The owner ship status of the volume container. Only when the status is "NotOwned", the delete operation on the volume container is permitted.
 * @property storageAccountCredentialId The path ID of storage account associated with the volume container.
 * @property totalCloudStorageUsageInBytes The total cloud storage for the volume container.
 * @property type The hierarchical type of the object.
 * @property volumeCount The number of volumes in the volume Container.
 */
public data class GetVolumeContainerResult(
    public val bandWidthRateInMbps: Int? = null,
    public val bandwidthSettingId: String? = null,
    public val encryptionKey: AsymmetricEncryptedSecretResponse? = null,
    public val encryptionStatus: String,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val ownerShipStatus: String,
    public val storageAccountCredentialId: String,
    public val totalCloudStorageUsageInBytes: Double,
    public val type: String,
    public val volumeCount: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.GetVolumeContainerResult):
            GetVolumeContainerResult = GetVolumeContainerResult(
            bandWidthRateInMbps = javaType.bandWidthRateInMbps().map({ args0 -> args0 }).orElse(null),
            bandwidthSettingId = javaType.bandwidthSettingId().map({ args0 -> args0 }).orElse(null),
            encryptionKey = javaType.encryptionKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storsimple.kotlin.outputs.AsymmetricEncryptedSecretResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            encryptionStatus = javaType.encryptionStatus(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            ownerShipStatus = javaType.ownerShipStatus(),
            storageAccountCredentialId = javaType.storageAccountCredentialId(),
            totalCloudStorageUsageInBytes = javaType.totalCloudStorageUsageInBytes(),
            type = javaType.type(),
            volumeCount = javaType.volumeCount(),
        )
    }
}
