@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The metadata of the volume container, that is being considered as part of a failover set.
 * @property volumeContainerId The path ID of the volume container.
 * @property volumes The list of metadata of volumes inside the volume container, which contains valid cloud snapshots.
 */
public data class VolumeContainerFailoverMetadataResponse(
    public val volumeContainerId: String? = null,
    public val volumes: List<VolumeFailoverMetadataResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.VolumeContainerFailoverMetadataResponse):
            VolumeContainerFailoverMetadataResponse = VolumeContainerFailoverMetadataResponse(
            volumeContainerId = javaType.volumeContainerId().map({ args0 -> args0 }).orElse(null),
            volumes = javaType.volumes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storsimple.kotlin.outputs.VolumeFailoverMetadataResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
