@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin

import com.pulumi.azurenative.streamanalytics.FunctionArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.AggregateFunctionPropertiesArgs
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.ScalarFunctionPropertiesArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A function object, containing all information associated with the named function. All functions are contained under a streaming job.
 * Azure REST API version: 2020-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * Other available API versions: 2016-03-01, 2021-10-01-preview.
 * ## Example Usage
 * ### Create a JavaScript function
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var function = new AzureNative.StreamAnalytics.Function("function", new()
 *     {
 *         FunctionName = "function8197",
 *         JobName = "sj8653",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.ScalarFunctionPropertiesArgs
 *         {
 *             Binding = new AzureNative.StreamAnalytics.Inputs.JavaScriptFunctionBindingArgs
 *             {
 *                 Script = "function (x, y) { return x + y; }",
 *                 Type = "Microsoft.StreamAnalytics/JavascriptUdf",
 *             },
 *             Inputs = new[]
 *             {
 *                 new AzureNative.StreamAnalytics.Inputs.FunctionInputArgs
 *                 {
 *                     DataType = "Any",
 *                 },
 *             },
 *             Output = new AzureNative.StreamAnalytics.Inputs.FunctionOutputArgs
 *             {
 *                 DataType = "Any",
 *             },
 *             Type = "Scalar",
 *         },
 *         ResourceGroupName = "sjrg1637",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewFunction(ctx, "function", &streamanalytics.FunctionArgs{
 * 			FunctionName: pulumi.String("function8197"),
 * 			JobName:      pulumi.String("sj8653"),
 * 			Properties: streamanalytics.ScalarFunctionProperties{
 * 				Binding: streamanalytics.JavaScriptFunctionBinding{
 * 					Script: "function (x, y) { return x + y; }",
 * 					Type:   "Microsoft.StreamAnalytics/JavascriptUdf",
 * 				},
 * 				Inputs: []streamanalytics.FunctionInputType{
 * 					{
 * 						DataType: "Any",
 * 					},
 * 				},
 * 				Output: streamanalytics.FunctionOutputType{
 * 					DataType: "Any",
 * 				},
 * 				Type: "Scalar",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg1637"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Function;
 * import com.pulumi.azurenative.streamanalytics.FunctionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var function = new Function("function", FunctionArgs.builder()
 *             .functionName("function8197")
 *             .jobName("sj8653")
 *             .properties(Map.ofEntries(
 *                 Map.entry("binding", Map.ofEntries(
 *                     Map.entry("script", "function (x, y) { return x + y; }"),
 *                     Map.entry("type", "Microsoft.StreamAnalytics/JavascriptUdf")
 *                 )),
 *                 Map.entry("inputs", Map.of("dataType", "Any")),
 *                 Map.entry("output", Map.of("dataType", "Any")),
 *                 Map.entry("type", "Scalar")
 *             ))
 *             .resourceGroupName("sjrg1637")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Azure ML function
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var function = new AzureNative.StreamAnalytics.Function("function", new()
 *     {
 *         FunctionName = "function588",
 *         JobName = "sj9093",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.ScalarFunctionPropertiesArgs
 *         {
 *             Binding = new AzureNative.StreamAnalytics.Inputs.AzureMachineLearningWebServiceFunctionBindingArgs
 *             {
 *                 ApiKey = "someApiKey==",
 *                 BatchSize = 1000,
 *                 Endpoint = "someAzureMLEndpointURL",
 *                 Inputs = new AzureNative.StreamAnalytics.Inputs.AzureMachineLearningWebServiceInputsArgs
 *                 {
 *                     ColumnNames = new[]
 *                     {
 *                         new AzureNative.StreamAnalytics.Inputs.AzureMachineLearningWebServiceInputColumnArgs
 *                         {
 *                             DataType = "string",
 *                             MapTo = 0,
 *                             Name = "tweet",
 *                         },
 *                     },
 *                     Name = "input1",
 *                 },
 *                 Outputs = new[]
 *                 {
 *                     new AzureNative.StreamAnalytics.Inputs.AzureMachineLearningWebServiceOutputColumnArgs
 *                     {
 *                         DataType = "string",
 *                         Name = "Sentiment",
 *                     },
 *                 },
 *                 Type = "Microsoft.MachineLearning/WebService",
 *             },
 *             Inputs = new[]
 *             {
 *                 new AzureNative.StreamAnalytics.Inputs.FunctionInputArgs
 *                 {
 *                     DataType = "nvarchar(max)",
 *                 },
 *             },
 *             Output = new AzureNative.StreamAnalytics.Inputs.FunctionOutputArgs
 *             {
 *                 DataType = "nvarchar(max)",
 *             },
 *             Type = "Scalar",
 *         },
 *         ResourceGroupName = "sjrg7",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewFunction(ctx, "function", &streamanalytics.FunctionArgs{
 * 			FunctionName: pulumi.String("function588"),
 * 			JobName:      pulumi.String("sj9093"),
 * 			Properties: streamanalytics.ScalarFunctionProperties{
 * 				Binding: streamanalytics.AzureMachineLearningWebServiceFunctionBinding{
 * 					ApiKey:    "someApiKey==",
 * 					BatchSize: 1000,
 * 					Endpoint:  "someAzureMLEndpointURL",
 * 					Inputs: streamanalytics.AzureMachineLearningWebServiceInputs{
 * 						ColumnNames: []streamanalytics.AzureMachineLearningWebServiceInputColumn{
 * 							{
 * 								DataType: "string",
 * 								MapTo:    0,
 * 								Name:     "tweet",
 * 							},
 * 						},
 * 						Name: "input1",
 * 					},
 * 					Outputs: []streamanalytics.AzureMachineLearningWebServiceOutputColumn{
 * 						{
 * 							DataType: "string",
 * 							Name:     "Sentiment",
 * 						},
 * 					},
 * 					Type: "Microsoft.MachineLearning/WebService",
 * 				},
 * 				Inputs: []streamanalytics.FunctionInputType{
 * 					{
 * 						DataType: "nvarchar(max)",
 * 					},
 * 				},
 * 				Output: streamanalytics.FunctionOutputType{
 * 					DataType: "nvarchar(max)",
 * 				},
 * 				Type: "Scalar",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg7"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Function;
 * import com.pulumi.azurenative.streamanalytics.FunctionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var function = new Function("function", FunctionArgs.builder()
 *             .functionName("function588")
 *             .jobName("sj9093")
 *             .properties(Map.ofEntries(
 *                 Map.entry("binding", Map.ofEntries(
 *                     Map.entry("apiKey", "someApiKey=="),
 *                     Map.entry("batchSize", 1000),
 *                     Map.entry("endpoint", "someAzureMLEndpointURL"),
 *                     Map.entry("inputs", Map.ofEntries(
 *                         Map.entry("columnNames", Map.ofEntries(
 *                             Map.entry("dataType", "string"),
 *                             Map.entry("mapTo", 0),
 *                             Map.entry("name", "tweet")
 *                         )),
 *                         Map.entry("name", "input1")
 *                     )),
 *                     Map.entry("outputs", Map.ofEntries(
 *                         Map.entry("dataType", "string"),
 *                         Map.entry("name", "Sentiment")
 *                     )),
 *                     Map.entry("type", "Microsoft.MachineLearning/WebService")
 *                 )),
 *                 Map.entry("inputs", Map.of("dataType", "nvarchar(max)")),
 *                 Map.entry("output", Map.of("dataType", "nvarchar(max)")),
 *                 Map.entry("type", "Scalar")
 *             ))
 *             .resourceGroupName("sjrg7")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:streamanalytics:Function function588 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions/{functionName}
 * ```
 * @property functionName The name of the function.
 * @property jobName The name of the streaming job.
 * @property name Resource name
 * @property properties The properties that are associated with a function.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class FunctionArgs(
    public val functionName: Output<String>? = null,
    public val jobName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties:
    Output<Either<AggregateFunctionPropertiesArgs, ScalarFunctionPropertiesArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.FunctionArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.FunctionArgs =
        com.pulumi.azurenative.streamanalytics.FunctionArgs.builder()
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionArgs].
 */
@PulumiTagMarker
public class FunctionArgsBuilder internal constructor() {
    private var functionName: Output<String>? = null

    private var jobName: Output<String>? = null

    private var name: Output<String>? = null

    private var properties:
        Output<Either<AggregateFunctionPropertiesArgs, ScalarFunctionPropertiesArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the function.
     */
    @JvmName("goucbuldnnoqejii")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value The name of the streaming job.
     */
    @JvmName("focybqoxlohmpsdu")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value Resource name
     */
    @JvmName("gydafslgfmvnvuki")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The properties that are associated with a function.
     */
    @JvmName("saccordnmgsawwml")
    public suspend
    fun properties(`value`: Output<Either<AggregateFunctionPropertiesArgs, ScalarFunctionPropertiesArgs>>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ffsbctqfhrutkgbx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the function.
     */
    @JvmName("ekojdfiphbfncdfa")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value The name of the streaming job.
     */
    @JvmName("pxmhhfnunicvkeas")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value Resource name
     */
    @JvmName("ummbikrvkudhslpn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The properties that are associated with a function.
     */
    @JvmName("frndfblhlqorjdeb")
    public suspend
    fun properties(`value`: Either<AggregateFunctionPropertiesArgs, ScalarFunctionPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The properties that are associated with a function.
     */
    @JvmName("vqtmyiyupmwfsepr")
    public fun properties(`value`: AggregateFunctionPropertiesArgs) {
        val toBeMapped = Either.ofLeft<AggregateFunctionPropertiesArgs,
            ScalarFunctionPropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The properties that are associated with a function.
     */
    @JvmName("ulsplkgjqlrtyfvr")
    public fun properties(`value`: ScalarFunctionPropertiesArgs) {
        val toBeMapped = Either.ofRight<AggregateFunctionPropertiesArgs,
            ScalarFunctionPropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oxbxdtjjyksmnvce")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): FunctionArgs = FunctionArgs(
        functionName = functionName,
        jobName = jobName,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
