@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin

import com.pulumi.azurenative.streamanalytics.kotlin.outputs.ReferenceInputPropertiesResponse
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.StreamInputPropertiesResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Input].
 */
@PulumiTagMarker
public class InputResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InputArgs = InputArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InputArgsBuilder.() -> Unit) {
        val builder = InputArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Input {
        val builtJavaResource = com.pulumi.azurenative.streamanalytics.Input(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Input(builtJavaResource)
    }
}

/**
 * An input object, containing all information associated with the named input. All inputs are contained under a streaming job.
 * Azure REST API version: 2020-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * Other available API versions: 2021-10-01-preview.
 * ## Example Usage
 * ### Create a Gateway Message Bus input
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var input = new AzureNative.StreamAnalytics.Input("input", new()
 *     {
 *         InputName = "input7970",
 *         JobName = "sj9742",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.StreamInputPropertiesArgs
 *         {
 *             Datasource = new AzureNative.StreamAnalytics.Inputs.GatewayMessageBusStreamInputDataSourceArgs
 *             {
 *                 Topic = "EdgeTopic1",
 *                 Type = "GatewayMessageBus",
 *             },
 *             Type = "Stream",
 *         },
 *         ResourceGroupName = "sjrg3467",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewInput(ctx, "input", &streamanalytics.InputArgs{
 * 			InputName: pulumi.String("input7970"),
 * 			JobName:   pulumi.String("sj9742"),
 * 			Properties: streamanalytics.StreamInputProperties{
 * 				Datasource: streamanalytics.GatewayMessageBusStreamInputDataSource{
 * 					Topic: "EdgeTopic1",
 * 					Type:  "GatewayMessageBus",
 * 				},
 * 				Type: "Stream",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg3467"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Input;
 * import com.pulumi.azurenative.streamanalytics.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var input = new Input("input", InputArgs.builder()
 *             .inputName("input7970")
 *             .jobName("sj9742")
 *             .properties(Map.ofEntries(
 *                 Map.entry("datasource", Map.ofEntries(
 *                     Map.entry("topic", "EdgeTopic1"),
 *                     Map.entry("type", "GatewayMessageBus")
 *                 )),
 *                 Map.entry("type", "Stream")
 *             ))
 *             .resourceGroupName("sjrg3467")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a reference blob input with CSV serialization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var input = new AzureNative.StreamAnalytics.Input("input", new()
 *     {
 *         InputName = "input7225",
 *         JobName = "sj9597",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.ReferenceInputPropertiesArgs
 *         {
 *             Datasource = new AzureNative.StreamAnalytics.Inputs.BlobReferenceInputDataSourceArgs
 *             {
 *                 Container = "state",
 *                 DateFormat = "yyyy/MM/dd",
 *                 PathPattern = "{date}/{time}",
 *                 StorageAccounts = new[]
 *                 {
 *                     new AzureNative.StreamAnalytics.Inputs.StorageAccountArgs
 *                     {
 *                         AccountKey = "someAccountKey==",
 *                         AccountName = "someAccountName",
 *                     },
 *                 },
 *                 TimeFormat = "HH",
 *                 Type = "Microsoft.Storage/Blob",
 *             },
 *             Serialization = new AzureNative.StreamAnalytics.Inputs.CsvSerializationArgs
 *             {
 *                 Encoding = "UTF8",
 *                 FieldDelimiter = ",",
 *                 Type = "Csv",
 *             },
 *             Type = "Reference",
 *         },
 *         ResourceGroupName = "sjrg8440",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewInput(ctx, "input", &streamanalytics.InputArgs{
 * 			InputName: pulumi.String("input7225"),
 * 			JobName:   pulumi.String("sj9597"),
 * 			Properties: streamanalytics.ReferenceInputProperties{
 * 				Datasource: streamanalytics.BlobReferenceInputDataSource{
 * 					Container:   "state",
 * 					DateFormat:  "yyyy/MM/dd",
 * 					PathPattern: "{date}/{time}",
 * 					StorageAccounts: []streamanalytics.StorageAccount{
 * 						{
 * 							AccountKey:  "someAccountKey==",
 * 							AccountName: "someAccountName",
 * 						},
 * 					},
 * 					TimeFormat: "HH",
 * 					Type:       "Microsoft.Storage/Blob",
 * 				},
 * 				Serialization: streamanalytics.CsvSerialization{
 * 					Encoding:       "UTF8",
 * 					FieldDelimiter: ",",
 * 					Type:           "Csv",
 * 				},
 * 				Type: "Reference",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg8440"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Input;
 * import com.pulumi.azurenative.streamanalytics.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var input = new Input("input", InputArgs.builder()
 *             .inputName("input7225")
 *             .jobName("sj9597")
 *             .properties(Map.ofEntries(
 *                 Map.entry("datasource", Map.ofEntries(
 *                     Map.entry("container", "state"),
 *                     Map.entry("dateFormat", "yyyy/MM/dd"),
 *                     Map.entry("pathPattern", "{date}/{time}"),
 *                     Map.entry("storageAccounts", Map.ofEntries(
 *                         Map.entry("accountKey", "someAccountKey=="),
 *                         Map.entry("accountName", "someAccountName")
 *                     )),
 *                     Map.entry("timeFormat", "HH"),
 *                     Map.entry("type", "Microsoft.Storage/Blob")
 *                 )),
 *                 Map.entry("serialization", Map.ofEntries(
 *                     Map.entry("encoding", "UTF8"),
 *                     Map.entry("fieldDelimiter", ","),
 *                     Map.entry("type", "Csv")
 *                 )),
 *                 Map.entry("type", "Reference")
 *             ))
 *             .resourceGroupName("sjrg8440")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a reference file input
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var input = new AzureNative.StreamAnalytics.Input("input", new()
 *     {
 *         InputName = "input7225",
 *         JobName = "sj9597",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.ReferenceInputPropertiesArgs
 *         {
 *             Datasource = new AzureNative.StreamAnalytics.Inputs.FileReferenceInputDataSourceArgs
 *             {
 *                 Path = "my/path",
 *                 Type = "File",
 *             },
 *             Type = "Reference",
 *         },
 *         ResourceGroupName = "sjrg8440",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewInput(ctx, "input", &streamanalytics.InputArgs{
 * 			InputName: pulumi.String("input7225"),
 * 			JobName:   pulumi.String("sj9597"),
 * 			Properties: streamanalytics.ReferenceInputProperties{
 * 				Datasource: streamanalytics.FileReferenceInputDataSource{
 * 					Path: "my/path",
 * 					Type: "File",
 * 				},
 * 				Type: "Reference",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg8440"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Input;
 * import com.pulumi.azurenative.streamanalytics.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var input = new Input("input", InputArgs.builder()
 *             .inputName("input7225")
 *             .jobName("sj9597")
 *             .properties(Map.ofEntries(
 *                 Map.entry("datasource", Map.ofEntries(
 *                     Map.entry("path", "my/path"),
 *                     Map.entry("type", "File")
 *                 )),
 *                 Map.entry("type", "Reference")
 *             ))
 *             .resourceGroupName("sjrg8440")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a stream Event Hub input with JSON serialization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var input = new AzureNative.StreamAnalytics.Input("input", new()
 *     {
 *         InputName = "input7425",
 *         JobName = "sj197",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.StreamInputPropertiesArgs
 *         {
 *             Datasource = new AzureNative.StreamAnalytics.Inputs.EventHubStreamInputDataSourceArgs
 *             {
 *                 ConsumerGroupName = "sdkconsumergroup",
 *                 EventHubName = "sdkeventhub",
 *                 ServiceBusNamespace = "sdktest",
 *                 SharedAccessPolicyKey = "someSharedAccessPolicyKey==",
 *                 SharedAccessPolicyName = "RootManageSharedAccessKey",
 *                 Type = "Microsoft.ServiceBus/EventHub",
 *             },
 *             Serialization = new AzureNative.StreamAnalytics.Inputs.JsonSerializationArgs
 *             {
 *                 Encoding = "UTF8",
 *                 Type = "Json",
 *             },
 *             Type = "Stream",
 *         },
 *         ResourceGroupName = "sjrg3139",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewInput(ctx, "input", &streamanalytics.InputArgs{
 * 			InputName: pulumi.String("input7425"),
 * 			JobName:   pulumi.String("sj197"),
 * 			Properties: streamanalytics.StreamInputProperties{
 * 				Datasource: streamanalytics.EventHubStreamInputDataSource{
 * 					ConsumerGroupName:      "sdkconsumergroup",
 * 					EventHubName:           "sdkeventhub",
 * 					ServiceBusNamespace:    "sdktest",
 * 					SharedAccessPolicyKey:  "someSharedAccessPolicyKey==",
 * 					SharedAccessPolicyName: "RootManageSharedAccessKey",
 * 					Type:                   "Microsoft.ServiceBus/EventHub",
 * 				},
 * 				Serialization: streamanalytics.JsonSerialization{
 * 					Encoding: "UTF8",
 * 					Type:     "Json",
 * 				},
 * 				Type: "Stream",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg3139"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Input;
 * import com.pulumi.azurenative.streamanalytics.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var input = new Input("input", InputArgs.builder()
 *             .inputName("input7425")
 *             .jobName("sj197")
 *             .properties(Map.ofEntries(
 *                 Map.entry("datasource", Map.ofEntries(
 *                     Map.entry("consumerGroupName", "sdkconsumergroup"),
 *                     Map.entry("eventHubName", "sdkeventhub"),
 *                     Map.entry("serviceBusNamespace", "sdktest"),
 *                     Map.entry("sharedAccessPolicyKey", "someSharedAccessPolicyKey=="),
 *                     Map.entry("sharedAccessPolicyName", "RootManageSharedAccessKey"),
 *                     Map.entry("type", "Microsoft.ServiceBus/EventHub")
 *                 )),
 *                 Map.entry("serialization", Map.ofEntries(
 *                     Map.entry("encoding", "UTF8"),
 *                     Map.entry("type", "Json")
 *                 )),
 *                 Map.entry("type", "Stream")
 *             ))
 *             .resourceGroupName("sjrg3139")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a stream IoT Hub input with Avro serialization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var input = new AzureNative.StreamAnalytics.Input("input", new()
 *     {
 *         InputName = "input7970",
 *         JobName = "sj9742",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.StreamInputPropertiesArgs
 *         {
 *             Datasource = new AzureNative.StreamAnalytics.Inputs.IoTHubStreamInputDataSourceArgs
 *             {
 *                 ConsumerGroupName = "sdkconsumergroup",
 *                 Endpoint = "messages/events",
 *                 IotHubNamespace = "iothub",
 *                 SharedAccessPolicyKey = "sharedAccessPolicyKey=",
 *                 SharedAccessPolicyName = "owner",
 *                 Type = "Microsoft.Devices/IotHubs",
 *             },
 *             Serialization = new AzureNative.StreamAnalytics.Inputs.AvroSerializationArgs
 *             {
 *                 Type = "Avro",
 *             },
 *             Type = "Stream",
 *         },
 *         ResourceGroupName = "sjrg3467",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewInput(ctx, "input", &streamanalytics.InputArgs{
 * 			InputName: pulumi.String("input7970"),
 * 			JobName:   pulumi.String("sj9742"),
 * 			Properties: streamanalytics.StreamInputProperties{
 * 				Datasource: streamanalytics.IoTHubStreamInputDataSource{
 * 					ConsumerGroupName:      "sdkconsumergroup",
 * 					Endpoint:               "messages/events",
 * 					IotHubNamespace:        "iothub",
 * 					SharedAccessPolicyKey:  "sharedAccessPolicyKey=",
 * 					SharedAccessPolicyName: "owner",
 * 					Type:                   "Microsoft.Devices/IotHubs",
 * 				},
 * 				Serialization: streamanalytics.AvroSerialization{
 * 					Type: "Avro",
 * 				},
 * 				Type: "Stream",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg3467"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Input;
 * import com.pulumi.azurenative.streamanalytics.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var input = new Input("input", InputArgs.builder()
 *             .inputName("input7970")
 *             .jobName("sj9742")
 *             .properties(Map.ofEntries(
 *                 Map.entry("datasource", Map.ofEntries(
 *                     Map.entry("consumerGroupName", "sdkconsumergroup"),
 *                     Map.entry("endpoint", "messages/events"),
 *                     Map.entry("iotHubNamespace", "iothub"),
 *                     Map.entry("sharedAccessPolicyKey", "sharedAccessPolicyKey="),
 *                     Map.entry("sharedAccessPolicyName", "owner"),
 *                     Map.entry("type", "Microsoft.Devices/IotHubs")
 *                 )),
 *                 Map.entry("serialization", Map.of("type", "Avro")),
 *                 Map.entry("type", "Stream")
 *             ))
 *             .resourceGroupName("sjrg3467")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a stream blob input with CSV serialization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var input = new AzureNative.StreamAnalytics.Input("input", new()
 *     {
 *         InputName = "input8899",
 *         JobName = "sj6695",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.StreamInputPropertiesArgs
 *         {
 *             Datasource = new AzureNative.StreamAnalytics.Inputs.BlobStreamInputDataSourceArgs
 *             {
 *                 Container = "state",
 *                 DateFormat = "yyyy/MM/dd",
 *                 PathPattern = "{date}/{time}",
 *                 SourcePartitionCount = 16,
 *                 StorageAccounts = new[]
 *                 {
 *                     new AzureNative.StreamAnalytics.Inputs.StorageAccountArgs
 *                     {
 *                         AccountKey = "someAccountKey==",
 *                         AccountName = "someAccountName",
 *                     },
 *                 },
 *                 TimeFormat = "HH",
 *                 Type = "Microsoft.Storage/Blob",
 *             },
 *             Serialization = new AzureNative.StreamAnalytics.Inputs.CsvSerializationArgs
 *             {
 *                 Encoding = "UTF8",
 *                 FieldDelimiter = ",",
 *                 Type = "Csv",
 *             },
 *             Type = "Stream",
 *         },
 *         ResourceGroupName = "sjrg8161",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewInput(ctx, "input", &streamanalytics.InputArgs{
 * 			InputName: pulumi.String("input8899"),
 * 			JobName:   pulumi.String("sj6695"),
 * 			Properties: streamanalytics.StreamInputProperties{
 * 				Datasource: streamanalytics.BlobStreamInputDataSource{
 * 					Container:            "state",
 * 					DateFormat:           "yyyy/MM/dd",
 * 					PathPattern:          "{date}/{time}",
 * 					SourcePartitionCount: 16,
 * 					StorageAccounts: []streamanalytics.StorageAccount{
 * 						{
 * 							AccountKey:  "someAccountKey==",
 * 							AccountName: "someAccountName",
 * 						},
 * 					},
 * 					TimeFormat: "HH",
 * 					Type:       "Microsoft.Storage/Blob",
 * 				},
 * 				Serialization: streamanalytics.CsvSerialization{
 * 					Encoding:       "UTF8",
 * 					FieldDelimiter: ",",
 * 					Type:           "Csv",
 * 				},
 * 				Type: "Stream",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg8161"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Input;
 * import com.pulumi.azurenative.streamanalytics.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var input = new Input("input", InputArgs.builder()
 *             .inputName("input8899")
 *             .jobName("sj6695")
 *             .properties(Map.ofEntries(
 *                 Map.entry("datasource", Map.ofEntries(
 *                     Map.entry("container", "state"),
 *                     Map.entry("dateFormat", "yyyy/MM/dd"),
 *                     Map.entry("pathPattern", "{date}/{time}"),
 *                     Map.entry("sourcePartitionCount", 16),
 *                     Map.entry("storageAccounts", Map.ofEntries(
 *                         Map.entry("accountKey", "someAccountKey=="),
 *                         Map.entry("accountName", "someAccountName")
 *                     )),
 *                     Map.entry("timeFormat", "HH"),
 *                     Map.entry("type", "Microsoft.Storage/Blob")
 *                 )),
 *                 Map.entry("serialization", Map.ofEntries(
 *                     Map.entry("encoding", "UTF8"),
 *                     Map.entry("fieldDelimiter", ","),
 *                     Map.entry("type", "Csv")
 *                 )),
 *                 Map.entry("type", "Stream")
 *             ))
 *             .resourceGroupName("sjrg8161")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:streamanalytics:Input input8899 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/inputs/{inputName}
 * ```
 */
public class Input internal constructor(
    override val javaResource: com.pulumi.azurenative.streamanalytics.Input,
) : KotlinCustomResource(javaResource, InputMapper) {
    /**
     * Resource name
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
     */
    public val properties:
        Output<Either<ReferenceInputPropertiesResponse, StreamInputPropertiesResponse>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.streamanalytics.kotlin.outputs.ReferenceInputPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.streamanalytics.kotlin.outputs.StreamInputPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
            )
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object InputMapper : ResourceMapper<Input> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.streamanalytics.Input::class == javaResource::class

    override fun map(javaResource: Resource): Input = Input(
        javaResource as
            com.pulumi.azurenative.streamanalytics.Input,
    )
}

/**
 * @see [Input].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Input].
 */
public suspend fun input(name: String, block: suspend InputResourceBuilder.() -> Unit): Input {
    val builder = InputResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Input].
 * @param name The _unique_ name of the resulting resource.
 */
public fun input(name: String): Input {
    val builder = InputResourceBuilder()
    builder.name(name)
    return builder.build()
}
