@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin

import com.pulumi.azurenative.streamanalytics.InputArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.ReferenceInputPropertiesArgs
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.StreamInputPropertiesArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An input object, containing all information associated with the named input. All inputs are contained under a streaming job.
 * Azure REST API version: 2020-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * Other available API versions: 2021-10-01-preview.
 * ## Example Usage
 * ### Create a Gateway Message Bus input
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var input = new AzureNative.StreamAnalytics.Input("input", new()
 *     {
 *         InputName = "input7970",
 *         JobName = "sj9742",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.StreamInputPropertiesArgs
 *         {
 *             Datasource = new AzureNative.StreamAnalytics.Inputs.GatewayMessageBusStreamInputDataSourceArgs
 *             {
 *                 Topic = "EdgeTopic1",
 *                 Type = "GatewayMessageBus",
 *             },
 *             Type = "Stream",
 *         },
 *         ResourceGroupName = "sjrg3467",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewInput(ctx, "input", &streamanalytics.InputArgs{
 * 			InputName: pulumi.String("input7970"),
 * 			JobName:   pulumi.String("sj9742"),
 * 			Properties: streamanalytics.StreamInputProperties{
 * 				Datasource: streamanalytics.GatewayMessageBusStreamInputDataSource{
 * 					Topic: "EdgeTopic1",
 * 					Type:  "GatewayMessageBus",
 * 				},
 * 				Type: "Stream",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg3467"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Input;
 * import com.pulumi.azurenative.streamanalytics.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var input = new Input("input", InputArgs.builder()
 *             .inputName("input7970")
 *             .jobName("sj9742")
 *             .properties(Map.ofEntries(
 *                 Map.entry("datasource", Map.ofEntries(
 *                     Map.entry("topic", "EdgeTopic1"),
 *                     Map.entry("type", "GatewayMessageBus")
 *                 )),
 *                 Map.entry("type", "Stream")
 *             ))
 *             .resourceGroupName("sjrg3467")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a reference blob input with CSV serialization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var input = new AzureNative.StreamAnalytics.Input("input", new()
 *     {
 *         InputName = "input7225",
 *         JobName = "sj9597",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.ReferenceInputPropertiesArgs
 *         {
 *             Datasource = new AzureNative.StreamAnalytics.Inputs.BlobReferenceInputDataSourceArgs
 *             {
 *                 Container = "state",
 *                 DateFormat = "yyyy/MM/dd",
 *                 PathPattern = "{date}/{time}",
 *                 StorageAccounts = new[]
 *                 {
 *                     new AzureNative.StreamAnalytics.Inputs.StorageAccountArgs
 *                     {
 *                         AccountKey = "someAccountKey==",
 *                         AccountName = "someAccountName",
 *                     },
 *                 },
 *                 TimeFormat = "HH",
 *                 Type = "Microsoft.Storage/Blob",
 *             },
 *             Serialization = new AzureNative.StreamAnalytics.Inputs.CsvSerializationArgs
 *             {
 *                 Encoding = "UTF8",
 *                 FieldDelimiter = ",",
 *                 Type = "Csv",
 *             },
 *             Type = "Reference",
 *         },
 *         ResourceGroupName = "sjrg8440",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewInput(ctx, "input", &streamanalytics.InputArgs{
 * 			InputName: pulumi.String("input7225"),
 * 			JobName:   pulumi.String("sj9597"),
 * 			Properties: streamanalytics.ReferenceInputProperties{
 * 				Datasource: streamanalytics.BlobReferenceInputDataSource{
 * 					Container:   "state",
 * 					DateFormat:  "yyyy/MM/dd",
 * 					PathPattern: "{date}/{time}",
 * 					StorageAccounts: []streamanalytics.StorageAccount{
 * 						{
 * 							AccountKey:  "someAccountKey==",
 * 							AccountName: "someAccountName",
 * 						},
 * 					},
 * 					TimeFormat: "HH",
 * 					Type:       "Microsoft.Storage/Blob",
 * 				},
 * 				Serialization: streamanalytics.CsvSerialization{
 * 					Encoding:       "UTF8",
 * 					FieldDelimiter: ",",
 * 					Type:           "Csv",
 * 				},
 * 				Type: "Reference",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg8440"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Input;
 * import com.pulumi.azurenative.streamanalytics.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var input = new Input("input", InputArgs.builder()
 *             .inputName("input7225")
 *             .jobName("sj9597")
 *             .properties(Map.ofEntries(
 *                 Map.entry("datasource", Map.ofEntries(
 *                     Map.entry("container", "state"),
 *                     Map.entry("dateFormat", "yyyy/MM/dd"),
 *                     Map.entry("pathPattern", "{date}/{time}"),
 *                     Map.entry("storageAccounts", Map.ofEntries(
 *                         Map.entry("accountKey", "someAccountKey=="),
 *                         Map.entry("accountName", "someAccountName")
 *                     )),
 *                     Map.entry("timeFormat", "HH"),
 *                     Map.entry("type", "Microsoft.Storage/Blob")
 *                 )),
 *                 Map.entry("serialization", Map.ofEntries(
 *                     Map.entry("encoding", "UTF8"),
 *                     Map.entry("fieldDelimiter", ","),
 *                     Map.entry("type", "Csv")
 *                 )),
 *                 Map.entry("type", "Reference")
 *             ))
 *             .resourceGroupName("sjrg8440")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a reference file input
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var input = new AzureNative.StreamAnalytics.Input("input", new()
 *     {
 *         InputName = "input7225",
 *         JobName = "sj9597",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.ReferenceInputPropertiesArgs
 *         {
 *             Datasource = new AzureNative.StreamAnalytics.Inputs.FileReferenceInputDataSourceArgs
 *             {
 *                 Path = "my/path",
 *                 Type = "File",
 *             },
 *             Type = "Reference",
 *         },
 *         ResourceGroupName = "sjrg8440",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewInput(ctx, "input", &streamanalytics.InputArgs{
 * 			InputName: pulumi.String("input7225"),
 * 			JobName:   pulumi.String("sj9597"),
 * 			Properties: streamanalytics.ReferenceInputProperties{
 * 				Datasource: streamanalytics.FileReferenceInputDataSource{
 * 					Path: "my/path",
 * 					Type: "File",
 * 				},
 * 				Type: "Reference",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg8440"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Input;
 * import com.pulumi.azurenative.streamanalytics.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var input = new Input("input", InputArgs.builder()
 *             .inputName("input7225")
 *             .jobName("sj9597")
 *             .properties(Map.ofEntries(
 *                 Map.entry("datasource", Map.ofEntries(
 *                     Map.entry("path", "my/path"),
 *                     Map.entry("type", "File")
 *                 )),
 *                 Map.entry("type", "Reference")
 *             ))
 *             .resourceGroupName("sjrg8440")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a stream Event Hub input with JSON serialization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var input = new AzureNative.StreamAnalytics.Input("input", new()
 *     {
 *         InputName = "input7425",
 *         JobName = "sj197",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.StreamInputPropertiesArgs
 *         {
 *             Datasource = new AzureNative.StreamAnalytics.Inputs.EventHubStreamInputDataSourceArgs
 *             {
 *                 ConsumerGroupName = "sdkconsumergroup",
 *                 EventHubName = "sdkeventhub",
 *                 ServiceBusNamespace = "sdktest",
 *                 SharedAccessPolicyKey = "someSharedAccessPolicyKey==",
 *                 SharedAccessPolicyName = "RootManageSharedAccessKey",
 *                 Type = "Microsoft.ServiceBus/EventHub",
 *             },
 *             Serialization = new AzureNative.StreamAnalytics.Inputs.JsonSerializationArgs
 *             {
 *                 Encoding = "UTF8",
 *                 Type = "Json",
 *             },
 *             Type = "Stream",
 *         },
 *         ResourceGroupName = "sjrg3139",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewInput(ctx, "input", &streamanalytics.InputArgs{
 * 			InputName: pulumi.String("input7425"),
 * 			JobName:   pulumi.String("sj197"),
 * 			Properties: streamanalytics.StreamInputProperties{
 * 				Datasource: streamanalytics.EventHubStreamInputDataSource{
 * 					ConsumerGroupName:      "sdkconsumergroup",
 * 					EventHubName:           "sdkeventhub",
 * 					ServiceBusNamespace:    "sdktest",
 * 					SharedAccessPolicyKey:  "someSharedAccessPolicyKey==",
 * 					SharedAccessPolicyName: "RootManageSharedAccessKey",
 * 					Type:                   "Microsoft.ServiceBus/EventHub",
 * 				},
 * 				Serialization: streamanalytics.JsonSerialization{
 * 					Encoding: "UTF8",
 * 					Type:     "Json",
 * 				},
 * 				Type: "Stream",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg3139"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Input;
 * import com.pulumi.azurenative.streamanalytics.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var input = new Input("input", InputArgs.builder()
 *             .inputName("input7425")
 *             .jobName("sj197")
 *             .properties(Map.ofEntries(
 *                 Map.entry("datasource", Map.ofEntries(
 *                     Map.entry("consumerGroupName", "sdkconsumergroup"),
 *                     Map.entry("eventHubName", "sdkeventhub"),
 *                     Map.entry("serviceBusNamespace", "sdktest"),
 *                     Map.entry("sharedAccessPolicyKey", "someSharedAccessPolicyKey=="),
 *                     Map.entry("sharedAccessPolicyName", "RootManageSharedAccessKey"),
 *                     Map.entry("type", "Microsoft.ServiceBus/EventHub")
 *                 )),
 *                 Map.entry("serialization", Map.ofEntries(
 *                     Map.entry("encoding", "UTF8"),
 *                     Map.entry("type", "Json")
 *                 )),
 *                 Map.entry("type", "Stream")
 *             ))
 *             .resourceGroupName("sjrg3139")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a stream IoT Hub input with Avro serialization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var input = new AzureNative.StreamAnalytics.Input("input", new()
 *     {
 *         InputName = "input7970",
 *         JobName = "sj9742",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.StreamInputPropertiesArgs
 *         {
 *             Datasource = new AzureNative.StreamAnalytics.Inputs.IoTHubStreamInputDataSourceArgs
 *             {
 *                 ConsumerGroupName = "sdkconsumergroup",
 *                 Endpoint = "messages/events",
 *                 IotHubNamespace = "iothub",
 *                 SharedAccessPolicyKey = "sharedAccessPolicyKey=",
 *                 SharedAccessPolicyName = "owner",
 *                 Type = "Microsoft.Devices/IotHubs",
 *             },
 *             Serialization = new AzureNative.StreamAnalytics.Inputs.AvroSerializationArgs
 *             {
 *                 Type = "Avro",
 *             },
 *             Type = "Stream",
 *         },
 *         ResourceGroupName = "sjrg3467",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewInput(ctx, "input", &streamanalytics.InputArgs{
 * 			InputName: pulumi.String("input7970"),
 * 			JobName:   pulumi.String("sj9742"),
 * 			Properties: streamanalytics.StreamInputProperties{
 * 				Datasource: streamanalytics.IoTHubStreamInputDataSource{
 * 					ConsumerGroupName:      "sdkconsumergroup",
 * 					Endpoint:               "messages/events",
 * 					IotHubNamespace:        "iothub",
 * 					SharedAccessPolicyKey:  "sharedAccessPolicyKey=",
 * 					SharedAccessPolicyName: "owner",
 * 					Type:                   "Microsoft.Devices/IotHubs",
 * 				},
 * 				Serialization: streamanalytics.AvroSerialization{
 * 					Type: "Avro",
 * 				},
 * 				Type: "Stream",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg3467"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Input;
 * import com.pulumi.azurenative.streamanalytics.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var input = new Input("input", InputArgs.builder()
 *             .inputName("input7970")
 *             .jobName("sj9742")
 *             .properties(Map.ofEntries(
 *                 Map.entry("datasource", Map.ofEntries(
 *                     Map.entry("consumerGroupName", "sdkconsumergroup"),
 *                     Map.entry("endpoint", "messages/events"),
 *                     Map.entry("iotHubNamespace", "iothub"),
 *                     Map.entry("sharedAccessPolicyKey", "sharedAccessPolicyKey="),
 *                     Map.entry("sharedAccessPolicyName", "owner"),
 *                     Map.entry("type", "Microsoft.Devices/IotHubs")
 *                 )),
 *                 Map.entry("serialization", Map.of("type", "Avro")),
 *                 Map.entry("type", "Stream")
 *             ))
 *             .resourceGroupName("sjrg3467")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a stream blob input with CSV serialization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var input = new AzureNative.StreamAnalytics.Input("input", new()
 *     {
 *         InputName = "input8899",
 *         JobName = "sj6695",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.StreamInputPropertiesArgs
 *         {
 *             Datasource = new AzureNative.StreamAnalytics.Inputs.BlobStreamInputDataSourceArgs
 *             {
 *                 Container = "state",
 *                 DateFormat = "yyyy/MM/dd",
 *                 PathPattern = "{date}/{time}",
 *                 SourcePartitionCount = 16,
 *                 StorageAccounts = new[]
 *                 {
 *                     new AzureNative.StreamAnalytics.Inputs.StorageAccountArgs
 *                     {
 *                         AccountKey = "someAccountKey==",
 *                         AccountName = "someAccountName",
 *                     },
 *                 },
 *                 TimeFormat = "HH",
 *                 Type = "Microsoft.Storage/Blob",
 *             },
 *             Serialization = new AzureNative.StreamAnalytics.Inputs.CsvSerializationArgs
 *             {
 *                 Encoding = "UTF8",
 *                 FieldDelimiter = ",",
 *                 Type = "Csv",
 *             },
 *             Type = "Stream",
 *         },
 *         ResourceGroupName = "sjrg8161",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewInput(ctx, "input", &streamanalytics.InputArgs{
 * 			InputName: pulumi.String("input8899"),
 * 			JobName:   pulumi.String("sj6695"),
 * 			Properties: streamanalytics.StreamInputProperties{
 * 				Datasource: streamanalytics.BlobStreamInputDataSource{
 * 					Container:            "state",
 * 					DateFormat:           "yyyy/MM/dd",
 * 					PathPattern:          "{date}/{time}",
 * 					SourcePartitionCount: 16,
 * 					StorageAccounts: []streamanalytics.StorageAccount{
 * 						{
 * 							AccountKey:  "someAccountKey==",
 * 							AccountName: "someAccountName",
 * 						},
 * 					},
 * 					TimeFormat: "HH",
 * 					Type:       "Microsoft.Storage/Blob",
 * 				},
 * 				Serialization: streamanalytics.CsvSerialization{
 * 					Encoding:       "UTF8",
 * 					FieldDelimiter: ",",
 * 					Type:           "Csv",
 * 				},
 * 				Type: "Stream",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg8161"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Input;
 * import com.pulumi.azurenative.streamanalytics.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var input = new Input("input", InputArgs.builder()
 *             .inputName("input8899")
 *             .jobName("sj6695")
 *             .properties(Map.ofEntries(
 *                 Map.entry("datasource", Map.ofEntries(
 *                     Map.entry("container", "state"),
 *                     Map.entry("dateFormat", "yyyy/MM/dd"),
 *                     Map.entry("pathPattern", "{date}/{time}"),
 *                     Map.entry("sourcePartitionCount", 16),
 *                     Map.entry("storageAccounts", Map.ofEntries(
 *                         Map.entry("accountKey", "someAccountKey=="),
 *                         Map.entry("accountName", "someAccountName")
 *                     )),
 *                     Map.entry("timeFormat", "HH"),
 *                     Map.entry("type", "Microsoft.Storage/Blob")
 *                 )),
 *                 Map.entry("serialization", Map.ofEntries(
 *                     Map.entry("encoding", "UTF8"),
 *                     Map.entry("fieldDelimiter", ","),
 *                     Map.entry("type", "Csv")
 *                 )),
 *                 Map.entry("type", "Stream")
 *             ))
 *             .resourceGroupName("sjrg8161")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:streamanalytics:Input input8899 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/inputs/{inputName}
 * ```
 * @property inputName The name of the input.
 * @property jobName The name of the streaming job.
 * @property name Resource name
 * @property properties The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class InputArgs(
    public val inputName: Output<String>? = null,
    public val jobName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<Either<ReferenceInputPropertiesArgs, StreamInputPropertiesArgs>>? =
        null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.InputArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.InputArgs =
        com.pulumi.azurenative.streamanalytics.InputArgs.builder()
            .inputName(inputName?.applyValue({ args0 -> args0 }))
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InputArgs].
 */
@PulumiTagMarker
public class InputArgsBuilder internal constructor() {
    private var inputName: Output<String>? = null

    private var jobName: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<Either<ReferenceInputPropertiesArgs, StreamInputPropertiesArgs>>? =
        null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the input.
     */
    @JvmName("aiakrkvsosenoeue")
    public suspend fun inputName(`value`: Output<String>) {
        this.inputName = value
    }

    /**
     * @param value The name of the streaming job.
     */
    @JvmName("mscjdpbanfgmwhtc")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value Resource name
     */
    @JvmName("noiemgqtwftapidv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("abcmvwviowvmlmje")
    public suspend
    fun properties(`value`: Output<Either<ReferenceInputPropertiesArgs, StreamInputPropertiesArgs>>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iasgfoysccncuvoi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the input.
     */
    @JvmName("dimwsncaesimafot")
    public suspend fun inputName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputName = mapped
    }

    /**
     * @param value The name of the streaming job.
     */
    @JvmName("ufbtsnljvbyrlbqs")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value Resource name
     */
    @JvmName("mmrrcmwsmrevyvfa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("psvyrslmuanwtttu")
    public suspend
    fun properties(`value`: Either<ReferenceInputPropertiesArgs, StreamInputPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("nkgngonarfegidbr")
    public fun properties(`value`: ReferenceInputPropertiesArgs) {
        val toBeMapped = Either.ofLeft<ReferenceInputPropertiesArgs, StreamInputPropertiesArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("iogteuvewktnqqvw")
    public fun properties(`value`: StreamInputPropertiesArgs) {
        val toBeMapped = Either.ofRight<ReferenceInputPropertiesArgs, StreamInputPropertiesArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("psclvjqbciahjohn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): InputArgs = InputArgs(
        inputName = inputName,
        jobName = jobName,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
