@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests.
 */
public enum class ClusterSkuName(
    public val javaValue: com.pulumi.azurenative.streamanalytics.enums.ClusterSkuName,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.enums.ClusterSkuName> {
    /**
     * The default SKU.
     */
    Default(com.pulumi.azurenative.streamanalytics.enums.ClusterSkuName.Default),
    ;

    override fun toJava(): com.pulumi.azurenative.streamanalytics.enums.ClusterSkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.enums.ClusterSkuName):
            ClusterSkuName = ClusterSkuName.values().first { it.javaValue == javaType }
    }
}
