@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.AzureDataLakeStoreOutputDataSourceArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.AuthenticationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes an Azure Data Lake Store output data source.
 * @property accountName The name of the Azure Data Lake Store account. Required on PUT (CreateOrReplace) requests.
 * @property authenticationMode Authentication Mode.
 * @property dateFormat The date format. Wherever {date} appears in filePathPrefix, the value of this property is used as the date format instead.
 * @property filePathPrefix The location of the file to which the output should be written to. Required on PUT (CreateOrReplace) requests.
 * @property refreshToken A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
 * @property tenantId The tenant id of the user used to obtain the refresh token. Required on PUT (CreateOrReplace) requests.
 * @property timeFormat The time format. Wherever {time} appears in filePathPrefix, the value of this property is used as the time format instead.
 * @property tokenUserDisplayName The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
 * @property tokenUserPrincipalName The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.DataLake/Accounts'.
 */
public data class AzureDataLakeStoreOutputDataSourceArgs(
    public val accountName: Output<String>? = null,
    public val authenticationMode: Output<Either<String, AuthenticationMode>>? = null,
    public val dateFormat: Output<String>? = null,
    public val filePathPrefix: Output<String>? = null,
    public val refreshToken: Output<String>? = null,
    public val tenantId: Output<String>? = null,
    public val timeFormat: Output<String>? = null,
    public val tokenUserDisplayName: Output<String>? = null,
    public val tokenUserPrincipalName: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.AzureDataLakeStoreOutputDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.AzureDataLakeStoreOutputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.AzureDataLakeStoreOutputDataSourceArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .authenticationMode(
                authenticationMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .dateFormat(dateFormat?.applyValue({ args0 -> args0 }))
            .filePathPrefix(filePathPrefix?.applyValue({ args0 -> args0 }))
            .refreshToken(refreshToken?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .timeFormat(timeFormat?.applyValue({ args0 -> args0 }))
            .tokenUserDisplayName(tokenUserDisplayName?.applyValue({ args0 -> args0 }))
            .tokenUserPrincipalName(tokenUserPrincipalName?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureDataLakeStoreOutputDataSourceArgs].
 */
@PulumiTagMarker
public class AzureDataLakeStoreOutputDataSourceArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var authenticationMode: Output<Either<String, AuthenticationMode>>? = null

    private var dateFormat: Output<String>? = null

    private var filePathPrefix: Output<String>? = null

    private var refreshToken: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var timeFormat: Output<String>? = null

    private var tokenUserDisplayName: Output<String>? = null

    private var tokenUserPrincipalName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the Azure Data Lake Store account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("tocktvgjxbgdyrjg")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("nqpsmkvrmwesemoi")
    public suspend fun authenticationMode(`value`: Output<Either<String, AuthenticationMode>>) {
        this.authenticationMode = value
    }

    /**
     * @param value The date format. Wherever {date} appears in filePathPrefix, the value of this property is used as the date format instead.
     */
    @JvmName("mhgsgqlbqmkixwvn")
    public suspend fun dateFormat(`value`: Output<String>) {
        this.dateFormat = value
    }

    /**
     * @param value The location of the file to which the output should be written to. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("lvafkoywalixcyot")
    public suspend fun filePathPrefix(`value`: Output<String>) {
        this.filePathPrefix = value
    }

    /**
     * @param value A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("qmlgebqxofvcbtcb")
    public suspend fun refreshToken(`value`: Output<String>) {
        this.refreshToken = value
    }

    /**
     * @param value The tenant id of the user used to obtain the refresh token. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("otqskwxouwdlgtsb")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The time format. Wherever {time} appears in filePathPrefix, the value of this property is used as the time format instead.
     */
    @JvmName("fqilgywlkxjjyoui")
    public suspend fun timeFormat(`value`: Output<String>) {
        this.timeFormat = value
    }

    /**
     * @param value The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
     */
    @JvmName("saqcjryuowaqofap")
    public suspend fun tokenUserDisplayName(`value`: Output<String>) {
        this.tokenUserDisplayName = value
    }

    /**
     * @param value The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
     */
    @JvmName("ugtxnetrsteyjxwd")
    public suspend fun tokenUserPrincipalName(`value`: Output<String>) {
        this.tokenUserPrincipalName = value
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.DataLake/Accounts'.
     */
    @JvmName("jicrsssunbjyihsj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the Azure Data Lake Store account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("jaupfvoqjvmwrcxf")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("icfcdmtcxiymfcnv")
    public suspend fun authenticationMode(`value`: Either<String, AuthenticationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("bvfyxycmvxmwspvg")
    public fun authenticationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("mydrvboylphhssxt")
    public fun authenticationMode(`value`: AuthenticationMode) {
        val toBeMapped = Either.ofRight<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value The date format. Wherever {date} appears in filePathPrefix, the value of this property is used as the date format instead.
     */
    @JvmName("seqhtbrdvxysvyqn")
    public suspend fun dateFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dateFormat = mapped
    }

    /**
     * @param value The location of the file to which the output should be written to. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("qawsfifgvatpgfcu")
    public suspend fun filePathPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePathPrefix = mapped
    }

    /**
     * @param value A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("boyydjirjbetusib")
    public suspend fun refreshToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    /**
     * @param value The tenant id of the user used to obtain the refresh token. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("kjgtjnrvxfxapvlo")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value The time format. Wherever {time} appears in filePathPrefix, the value of this property is used as the time format instead.
     */
    @JvmName("glpdktpmkqtfqwah")
    public suspend fun timeFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeFormat = mapped
    }

    /**
     * @param value The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
     */
    @JvmName("kpnlpvnwnofndghi")
    public suspend fun tokenUserDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenUserDisplayName = mapped
    }

    /**
     * @param value The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
     */
    @JvmName("uvdgyjvbxuiqgdpr")
    public suspend fun tokenUserPrincipalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenUserPrincipalName = mapped
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.DataLake/Accounts'.
     */
    @JvmName("nbjmibaiavhtomdg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureDataLakeStoreOutputDataSourceArgs =
        AzureDataLakeStoreOutputDataSourceArgs(
            accountName = accountName,
            authenticationMode = authenticationMode,
            dateFormat = dateFormat,
            filePathPrefix = filePathPrefix,
            refreshToken = refreshToken,
            tenantId = tenantId,
            timeFormat = timeFormat,
            tokenUserDisplayName = tokenUserDisplayName,
            tokenUserPrincipalName = tokenUserPrincipalName,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
