@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceInputsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The inputs for the Azure Machine Learning web service endpoint.
 * @property columnNames A list of input columns for the Azure Machine Learning web service endpoint.
 * @property name The name of the input. This is the name provided while authoring the endpoint.
 */
public data class AzureMachineLearningWebServiceInputsArgs(
    public val columnNames: Output<List<AzureMachineLearningWebServiceInputColumnArgs>>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceInputsArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceInputsArgs =
        com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceInputsArgs.builder()
            .columnNames(
                columnNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureMachineLearningWebServiceInputsArgs].
 */
@PulumiTagMarker
public class AzureMachineLearningWebServiceInputsArgsBuilder internal constructor() {
    private var columnNames: Output<List<AzureMachineLearningWebServiceInputColumnArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value A list of input columns for the Azure Machine Learning web service endpoint.
     */
    @JvmName("lwpfegnehriwyaya")
    public suspend
    fun columnNames(`value`: Output<List<AzureMachineLearningWebServiceInputColumnArgs>>) {
        this.columnNames = value
    }

    @JvmName("hpmntmejbpwlfjui")
    public suspend fun columnNames(
        vararg
        values: Output<AzureMachineLearningWebServiceInputColumnArgs>,
    ) {
        this.columnNames = Output.all(values.asList())
    }

    /**
     * @param values A list of input columns for the Azure Machine Learning web service endpoint.
     */
    @JvmName("orrfhlhslvxiyedi")
    public suspend
    fun columnNames(values: List<Output<AzureMachineLearningWebServiceInputColumnArgs>>) {
        this.columnNames = Output.all(values)
    }

    /**
     * @param value The name of the input. This is the name provided while authoring the endpoint.
     */
    @JvmName("vwdkkmwvtkyvoluf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of input columns for the Azure Machine Learning web service endpoint.
     */
    @JvmName("kjggpxudrliyrlek")
    public suspend fun columnNames(`value`: List<AzureMachineLearningWebServiceInputColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnNames = mapped
    }

    /**
     * @param argument A list of input columns for the Azure Machine Learning web service endpoint.
     */
    @JvmName("iflgdhnsbyvcfkrk")
    public suspend
    fun columnNames(argument: List<suspend AzureMachineLearningWebServiceInputColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureMachineLearningWebServiceInputColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.columnNames = mapped
    }

    /**
     * @param argument A list of input columns for the Azure Machine Learning web service endpoint.
     */
    @JvmName("eawwfiyonxbfkthb")
    public suspend fun columnNames(
        vararg
        argument: suspend AzureMachineLearningWebServiceInputColumnArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AzureMachineLearningWebServiceInputColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.columnNames = mapped
    }

    /**
     * @param argument A list of input columns for the Azure Machine Learning web service endpoint.
     */
    @JvmName("xonnlbohlcnhaonx")
    public suspend
    fun columnNames(argument: suspend AzureMachineLearningWebServiceInputColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureMachineLearningWebServiceInputColumnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.columnNames = mapped
    }

    /**
     * @param values A list of input columns for the Azure Machine Learning web service endpoint.
     */
    @JvmName("cgtdnpkarajxlokf")
    public suspend fun columnNames(vararg values: AzureMachineLearningWebServiceInputColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnNames = mapped
    }

    /**
     * @param value The name of the input. This is the name provided while authoring the endpoint.
     */
    @JvmName("ogmplvwkugqtxoku")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AzureMachineLearningWebServiceInputsArgs =
        AzureMachineLearningWebServiceInputsArgs(
            columnNames = columnNames,
            name = name,
        )
}
