@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.ClusterInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties associated with a Stream Analytics cluster.
 * @property id The resource id of cluster.
 */
public data class ClusterInfoArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.ClusterInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.ClusterInfoArgs =
        com.pulumi.azurenative.streamanalytics.inputs.ClusterInfoArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterInfoArgs].
 */
@PulumiTagMarker
public class ClusterInfoArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value The resource id of cluster.
     */
    @JvmName("cqjmeslwanyrsbtj")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The resource id of cluster.
     */
    @JvmName("lvhvrcvxuikvkbhv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ClusterInfoArgs = ClusterInfoArgs(
        id = id,
    )
}
