@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.ClusterSkuArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.ClusterSkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate) requests.
 * @property capacity Denotes the number of streaming units the cluster can support. Valid values for this property are multiples of 36 with a minimum value of 36 and maximum value of 216. Required on PUT (CreateOrUpdate) requests.
 * @property name Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests.
 */
public data class ClusterSkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<Either<String, ClusterSkuName>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.ClusterSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.ClusterSkuArgs =
        com.pulumi.azurenative.streamanalytics.inputs.ClusterSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterSkuArgs].
 */
@PulumiTagMarker
public class ClusterSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<Either<String, ClusterSkuName>>? = null

    /**
     * @param value Denotes the number of streaming units the cluster can support. Valid values for this property are multiples of 36 with a minimum value of 36 and maximum value of 216. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("ghuhxipwmmedcssn")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("qbumafvhrfanbtho")
    public suspend fun name(`value`: Output<Either<String, ClusterSkuName>>) {
        this.name = value
    }

    /**
     * @param value Denotes the number of streaming units the cluster can support. Valid values for this property are multiples of 36 with a minimum value of 36 and maximum value of 216. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("tdgovsroeykucpwq")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("rdgkyxjuytmtprxk")
    public suspend fun name(`value`: Either<String, ClusterSkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("avnlkvqypnrciblf")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClusterSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("gvnaovjfoiqppotp")
    public fun name(`value`: ClusterSkuName) {
        val toBeMapped = Either.ofRight<String, ClusterSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ClusterSkuArgs = ClusterSkuArgs(
        capacity = capacity,
        name = name,
    )
}
