@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.JavaScriptFunctionBindingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The binding to a JavaScript function.
 * @property script The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'
 * @property type Indicates the function binding type.
 * Expected value is 'Microsoft.StreamAnalytics/JavascriptUdf'.
 */
public data class JavaScriptFunctionBindingArgs(
    public val script: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.JavaScriptFunctionBindingArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.JavaScriptFunctionBindingArgs =
        com.pulumi.azurenative.streamanalytics.inputs.JavaScriptFunctionBindingArgs.builder()
            .script(script?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JavaScriptFunctionBindingArgs].
 */
@PulumiTagMarker
public class JavaScriptFunctionBindingArgsBuilder internal constructor() {
    private var script: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'
     */
    @JvmName("hxtwtpcraiykmgrw")
    public suspend fun script(`value`: Output<String>) {
        this.script = value
    }

    /**
     * @param value Indicates the function binding type.
     * Expected value is 'Microsoft.StreamAnalytics/JavascriptUdf'.
     */
    @JvmName("yqfharqxwevljplj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'
     */
    @JvmName("ifpqktltvltprqlj")
    public suspend fun script(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.script = mapped
    }

    /**
     * @param value Indicates the function binding type.
     * Expected value is 'Microsoft.StreamAnalytics/JavascriptUdf'.
     */
    @JvmName("ennvmjsiuuwsxdoq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JavaScriptFunctionBindingArgs = JavaScriptFunctionBindingArgs(
        script = script,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
