@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.ParquetSerializationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes how data from an input is serialized or how data is serialized when written to an output in Parquet format.
 * @property type Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Parquet'.
 */
public data class ParquetSerializationArgs(
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.ParquetSerializationArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.ParquetSerializationArgs =
        com.pulumi.azurenative.streamanalytics.inputs.ParquetSerializationArgs.builder()
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParquetSerializationArgs].
 */
@PulumiTagMarker
public class ParquetSerializationArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Parquet'.
     */
    @JvmName("kahovsutlrfjiryu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Parquet'.
     */
    @JvmName("aceisysmsklqehri")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ParquetSerializationArgs = ParquetSerializationArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
