@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an Azure Data Lake Store output data source.
 * @property accountName The name of the Azure Data Lake Store account. Required on PUT (CreateOrReplace) requests.
 * @property authenticationMode Authentication Mode.
 * @property dateFormat The date format. Wherever {date} appears in filePathPrefix, the value of this property is used as the date format instead.
 * @property filePathPrefix The location of the file to which the output should be written to. Required on PUT (CreateOrReplace) requests.
 * @property refreshToken A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
 * @property tenantId The tenant id of the user used to obtain the refresh token. Required on PUT (CreateOrReplace) requests.
 * @property timeFormat The time format. Wherever {time} appears in filePathPrefix, the value of this property is used as the time format instead.
 * @property tokenUserDisplayName The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
 * @property tokenUserPrincipalName The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.DataLake/Accounts'.
 */
public data class AzureDataLakeStoreOutputDataSourceResponse(
    public val accountName: String? = null,
    public val authenticationMode: String? = null,
    public val dateFormat: String? = null,
    public val filePathPrefix: String? = null,
    public val refreshToken: String? = null,
    public val tenantId: String? = null,
    public val timeFormat: String? = null,
    public val tokenUserDisplayName: String? = null,
    public val tokenUserPrincipalName: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.AzureDataLakeStoreOutputDataSourceResponse):
            AzureDataLakeStoreOutputDataSourceResponse = AzureDataLakeStoreOutputDataSourceResponse(
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
            authenticationMode = javaType.authenticationMode().map({ args0 -> args0 }).orElse(null),
            dateFormat = javaType.dateFormat().map({ args0 -> args0 }).orElse(null),
            filePathPrefix = javaType.filePathPrefix().map({ args0 -> args0 }).orElse(null),
            refreshToken = javaType.refreshToken().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            timeFormat = javaType.timeFormat().map({ args0 -> args0 }).orElse(null),
            tokenUserDisplayName = javaType.tokenUserDisplayName().map({ args0 -> args0 }).orElse(null),
            tokenUserPrincipalName = javaType.tokenUserPrincipalName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
