@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Describes an Azure SQL database output data source.
 * @property authenticationMode Authentication Mode.
 * @property database The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 * @property maxBatchCount Max Batch count for write to Sql database, the default value is 10,000. Optional on PUT requests.
 * @property maxWriterCount Max Writer count, currently only 1(single writer) and 0(based on query partition) are available. Optional on PUT requests.
 * @property password The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 * @property server The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 * @property table The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.Sql/Server/Database'.
 * @property user The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 */
public data class AzureSqlDatabaseOutputDataSourceResponse(
    public val authenticationMode: String? = null,
    public val database: String? = null,
    public val maxBatchCount: Double? = null,
    public val maxWriterCount: Double? = null,
    public val password: String? = null,
    public val server: String? = null,
    public val table: String? = null,
    public val type: String,
    public val user: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.AzureSqlDatabaseOutputDataSourceResponse):
            AzureSqlDatabaseOutputDataSourceResponse = AzureSqlDatabaseOutputDataSourceResponse(
            authenticationMode = javaType.authenticationMode().map({ args0 -> args0 }).orElse(null),
            database = javaType.database().map({ args0 -> args0 }).orElse(null),
            maxBatchCount = javaType.maxBatchCount().map({ args0 -> args0 }).orElse(null),
            maxWriterCount = javaType.maxWriterCount().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            server = javaType.server().map({ args0 -> args0 }).orElse(null),
            table = javaType.table().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            user = javaType.user().map({ args0 -> args0 }).orElse(null),
        )
    }
}
