@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Condition applicable to the resource, or to the job overall, that warrant customer attention.
 * @property code The opaque diagnostic code.
 * @property message The human-readable message describing the condition in detail. Localized in the Accept-Language of the client request.
 * @property since The UTC timestamp of when the condition started. Customers should be able to find a corresponding event in the ops log around this time.
 */
public data class DiagnosticConditionResponse(
    public val code: String,
    public val message: String,
    public val since: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.DiagnosticConditionResponse):
            DiagnosticConditionResponse = DiagnosticConditionResponse(
            code = javaType.code(),
            message = javaType.message(),
            since = javaType.since(),
        )
    }
}
