@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a Gateway Message Bus output data source.
 * @property topic The name of the Service Bus topic.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'GatewayMessageBus'.
 */
public data class GatewayMessageBusOutputDataSourceResponse(
    public val topic: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.GatewayMessageBusOutputDataSourceResponse):
            GatewayMessageBusOutputDataSourceResponse = GatewayMessageBusOutputDataSourceResponse(
            topic = javaType.topic().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
