@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of read-only information about the state of the connection to the private remote resource.
 * @property actionsRequired A message indicating if changes on the service provider require any updates on the consumer.
 * @property description The reason for approval/rejection of the connection.
 * @property status Indicates whether the connection has been Approved/Rejected/Removed by the owner of the remote resource/service.
 */
public data class PrivateLinkConnectionStateResponse(
    public val actionsRequired: String,
    public val description: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.PrivateLinkConnectionStateResponse):
            PrivateLinkConnectionStateResponse = PrivateLinkConnectionStateResponse(
            actionsRequired = javaType.actionsRequired(),
            description = javaType.description(),
            status = javaType.status(),
        )
    }
}
