@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.subscription.kotlin

import com.pulumi.azurenative.subscription.AliasArgs.builder
import com.pulumi.azurenative.subscription.kotlin.inputs.PutAliasRequestPropertiesArgs
import com.pulumi.azurenative.subscription.kotlin.inputs.PutAliasRequestPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Subscription Information with the alias.
 * Azure REST API version: 2021-10-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2020-09-01.
 * ## Example Usage
 * ### CreateAlias
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @alias = new AzureNative.Subscription.Alias("alias", new()
 *     {
 *         AliasName = "aliasForNewSub",
 *         Properties = new AzureNative.Subscription.Inputs.PutAliasRequestPropertiesArgs
 *         {
 *             AdditionalProperties = new AzureNative.Subscription.Inputs.PutAliasRequestAdditionalPropertiesArgs
 *             {
 *                 SubscriptionOwnerId = "f09b39eb-c496-482c-9ab9-afd799572f4c",
 *                 SubscriptionTenantId = "66f6e4d6-07dc-4aea-94ea-e12d3026a3c8",
 *                 Tags =
 *                 {
 *                     { "tag1", "Messi" },
 *                     { "tag2", "Ronaldo" },
 *                     { "tag3", "Lebron" },
 *                 },
 *             },
 *             BillingScope = "/billingAccounts/af6231a7-7f8d-4fcc-a993-dd8466108d07:c663dac6-a9a5-405a-8938-cd903e12ab5b_2019_05_31/billingProfiles/QWDQ-QWHI-AUW-SJDO-DJH/invoiceSections/FEUF-EUHE-ISJ-SKDW-DJH",
 *             DisplayName = "Test Subscription",
 *             Workload = "Production",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/subscription/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := subscription.NewAlias(ctx, "alias", &subscription.AliasArgs{
 * 			AliasName: pulumi.String("aliasForNewSub"),
 * 			Properties: subscription.SubscriptionAliasResponsePropertiesResponse{
 * 				AdditionalProperties: &subscription.PutAliasRequestAdditionalPropertiesArgs{
 * 					SubscriptionOwnerId:  pulumi.String("f09b39eb-c496-482c-9ab9-afd799572f4c"),
 * 					SubscriptionTenantId: pulumi.String("66f6e4d6-07dc-4aea-94ea-e12d3026a3c8"),
 * 					Tags: pulumi.StringMap{
 * 						"tag1": pulumi.String("Messi"),
 * 						"tag2": pulumi.String("Ronaldo"),
 * 						"tag3": pulumi.String("Lebron"),
 * 					},
 * 				},
 * 				BillingScope: pulumi.String("/billingAccounts/af6231a7-7f8d-4fcc-a993-dd8466108d07:c663dac6-a9a5-405a-8938-cd903e12ab5b_2019_05_31/billingProfiles/QWDQ-QWHI-AUW-SJDO-DJH/invoiceSections/FEUF-EUHE-ISJ-SKDW-DJH"),
 * 				DisplayName:  pulumi.String("Test Subscription"),
 * 				Workload:     pulumi.String("Production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.subscription.Alias;
 * import com.pulumi.azurenative.subscription.AliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alias = new Alias("alias", AliasArgs.builder()
 *             .aliasName("aliasForNewSub")
 *             .properties(Map.ofEntries(
 *                 Map.entry("additionalProperties", Map.ofEntries(
 *                     Map.entry("subscriptionOwnerId", "f09b39eb-c496-482c-9ab9-afd799572f4c"),
 *                     Map.entry("subscriptionTenantId", "66f6e4d6-07dc-4aea-94ea-e12d3026a3c8"),
 *                     Map.entry("tags", Map.ofEntries(
 *                         Map.entry("tag1", "Messi"),
 *                         Map.entry("tag2", "Ronaldo"),
 *                         Map.entry("tag3", "Lebron")
 *                     ))
 *                 )),
 *                 Map.entry("billingScope", "/billingAccounts/af6231a7-7f8d-4fcc-a993-dd8466108d07:c663dac6-a9a5-405a-8938-cd903e12ab5b_2019_05_31/billingProfiles/QWDQ-QWHI-AUW-SJDO-DJH/invoiceSections/FEUF-EUHE-ISJ-SKDW-DJH"),
 *                 Map.entry("displayName", "Test Subscription"),
 *                 Map.entry("workload", "Production")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:subscription:Alias string /providers/Microsoft.Subscription/aliases/{aliasName}
 * ```
 * @property aliasName AliasName is the name for the subscription creation request. Note that this is not the same as subscription name and this doesn’t have any other lifecycle need beyond the request for subscription creation.
 * @property properties Put alias request properties.
 */
public data class AliasArgs(
    public val aliasName: Output<String>? = null,
    public val properties: Output<PutAliasRequestPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.subscription.AliasArgs> {
    override fun toJava(): com.pulumi.azurenative.subscription.AliasArgs =
        com.pulumi.azurenative.subscription.AliasArgs.builder()
            .aliasName(aliasName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AliasArgs].
 */
@PulumiTagMarker
public class AliasArgsBuilder internal constructor() {
    private var aliasName: Output<String>? = null

    private var properties: Output<PutAliasRequestPropertiesArgs>? = null

    /**
     * @param value AliasName is the name for the subscription creation request. Note that this is not the same as subscription name and this doesn’t have any other lifecycle need beyond the request for subscription creation.
     */
    @JvmName("bykanqjrpijdmadp")
    public suspend fun aliasName(`value`: Output<String>) {
        this.aliasName = value
    }

    /**
     * @param value Put alias request properties.
     */
    @JvmName("dhxkllecaavadvkf")
    public suspend fun properties(`value`: Output<PutAliasRequestPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value AliasName is the name for the subscription creation request. Note that this is not the same as subscription name and this doesn’t have any other lifecycle need beyond the request for subscription creation.
     */
    @JvmName("dvoxglvngvcivrdi")
    public suspend fun aliasName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliasName = mapped
    }

    /**
     * @param value Put alias request properties.
     */
    @JvmName("posceujhmuuvrjjl")
    public suspend fun properties(`value`: PutAliasRequestPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Put alias request properties.
     */
    @JvmName("drsdbdroofxbsukv")
    public suspend fun properties(argument: suspend PutAliasRequestPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PutAliasRequestPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): AliasArgs = AliasArgs(
        aliasName = aliasName,
        properties = properties,
    )
}
