@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.EventGridDataConnectionArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.BlobStorageEventType
import com.pulumi.azurenative.synapse.kotlin.enums.EventGridDataFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing an Event Grid data connection.
 * Azure REST API version: 2021-06-01-preview.
 * ## Example Usage
 * ### KustoPoolDataConnectionsCreateOrUpdate.json
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventGridDataConnection = new AzureNative.Synapse.EventGridDataConnection("eventGridDataConnection", new()
 *     {
 *         DataConnectionName = "DataConnections8",
 *         DatabaseName = "KustoDatabase8",
 *         KustoPoolName = "kustoclusterrptest4",
 *         ResourceGroupName = "kustorptest",
 *         WorkspaceName = "synapseWorkspaceName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewEventGridDataConnection(ctx, "eventGridDataConnection", &synapse.EventGridDataConnectionArgs{
 * 			DataConnectionName: pulumi.String("DataConnections8"),
 * 			DatabaseName:       pulumi.String("KustoDatabase8"),
 * 			KustoPoolName:      pulumi.String("kustoclusterrptest4"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 			WorkspaceName:      pulumi.String("synapseWorkspaceName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.EventGridDataConnection;
 * import com.pulumi.azurenative.synapse.EventGridDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventGridDataConnection = new EventGridDataConnection("eventGridDataConnection", EventGridDataConnectionArgs.builder()
 *             .dataConnectionName("DataConnections8")
 *             .databaseName("KustoDatabase8")
 *             .kustoPoolName("kustoclusterrptest4")
 *             .resourceGroupName("kustorptest")
 *             .workspaceName("synapseWorkspaceName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:EventGridDataConnection KustoClusterRPTest4/KustoDatabase8/DataConnections8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/databases/{databaseName}/dataConnections/{dataConnectionName}
 * ```
 * @property blobStorageEventType The name of blob storage event type to process.
 * @property consumerGroup The event hub consumer group.
 * @property dataConnectionName The name of the data connection.
 * @property dataFormat The data format of the message. Optionally the data format can be added to each message.
 * @property databaseName The name of the database in the Kusto pool.
 * @property eventHubResourceId The resource ID where the event grid is configured to send events.
 * @property ignoreFirstRecord A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file
 * @property kind Kind of the endpoint for the data connection
 * Expected value is 'EventGrid'.
 * @property kustoPoolName The name of the Kusto pool.
 * @property location Resource location.
 * @property mappingRuleName The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageAccountResourceId The resource ID of the storage account where the data resides.
 * @property tableName The table where the data should be ingested. Optionally the table information can be added to each message.
 * @property workspaceName The name of the workspace.
 */
public data class EventGridDataConnectionArgs(
    public val blobStorageEventType: Output<Either<String, BlobStorageEventType>>? = null,
    public val consumerGroup: Output<String>? = null,
    public val dataConnectionName: Output<String>? = null,
    public val dataFormat: Output<Either<String, EventGridDataFormat>>? = null,
    public val databaseName: Output<String>? = null,
    public val eventHubResourceId: Output<String>? = null,
    public val ignoreFirstRecord: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val kustoPoolName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val mappingRuleName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccountResourceId: Output<String>? = null,
    public val tableName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.EventGridDataConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.EventGridDataConnectionArgs =
        com.pulumi.azurenative.synapse.EventGridDataConnectionArgs.builder()
            .blobStorageEventType(
                blobStorageEventType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .consumerGroup(consumerGroup?.applyValue({ args0 -> args0 }))
            .dataConnectionName(dataConnectionName?.applyValue({ args0 -> args0 }))
            .dataFormat(
                dataFormat?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .eventHubResourceId(eventHubResourceId?.applyValue({ args0 -> args0 }))
            .ignoreFirstRecord(ignoreFirstRecord?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .kustoPoolName(kustoPoolName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mappingRuleName(mappingRuleName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccountResourceId(storageAccountResourceId?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventGridDataConnectionArgs].
 */
@PulumiTagMarker
public class EventGridDataConnectionArgsBuilder internal constructor() {
    private var blobStorageEventType: Output<Either<String, BlobStorageEventType>>? = null

    private var consumerGroup: Output<String>? = null

    private var dataConnectionName: Output<String>? = null

    private var dataFormat: Output<Either<String, EventGridDataFormat>>? = null

    private var databaseName: Output<String>? = null

    private var eventHubResourceId: Output<String>? = null

    private var ignoreFirstRecord: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var kustoPoolName: Output<String>? = null

    private var location: Output<String>? = null

    private var mappingRuleName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccountResourceId: Output<String>? = null

    private var tableName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of blob storage event type to process.
     */
    @JvmName("cmmjgueaudttwnvd")
    public suspend fun blobStorageEventType(`value`: Output<Either<String, BlobStorageEventType>>) {
        this.blobStorageEventType = value
    }

    /**
     * @param value The event hub consumer group.
     */
    @JvmName("yowwrbrddbyrjqqg")
    public suspend fun consumerGroup(`value`: Output<String>) {
        this.consumerGroup = value
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("frhgupebcbilcfwm")
    public suspend fun dataConnectionName(`value`: Output<String>) {
        this.dataConnectionName = value
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("aqlquyweejqmsyyx")
    public suspend fun dataFormat(`value`: Output<Either<String, EventGridDataFormat>>) {
        this.dataFormat = value
    }

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("pihbfkjeiqjltapq")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The resource ID where the event grid is configured to send events.
     */
    @JvmName("xilpxqhepjjhiset")
    public suspend fun eventHubResourceId(`value`: Output<String>) {
        this.eventHubResourceId = value
    }

    /**
     * @param value A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file
     */
    @JvmName("vcdmrwmnsnhsxcgq")
    public suspend fun ignoreFirstRecord(`value`: Output<Boolean>) {
        this.ignoreFirstRecord = value
    }

    /**
     * @param value Kind of the endpoint for the data connection
     * Expected value is 'EventGrid'.
     */
    @JvmName("xgmgmgdmlwkoawyf")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("jyuhrjptqsktlavc")
    public suspend fun kustoPoolName(`value`: Output<String>) {
        this.kustoPoolName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("sohfubgyxiyqtsom")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    @JvmName("dtiayoaqfehmbxac")
    public suspend fun mappingRuleName(`value`: Output<String>) {
        this.mappingRuleName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("imprhktpjepxksrs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource ID of the storage account where the data resides.
     */
    @JvmName("qatpgesfjhqtpsvw")
    public suspend fun storageAccountResourceId(`value`: Output<String>) {
        this.storageAccountResourceId = value
    }

    /**
     * @param value The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    @JvmName("gxuiinrcphlltime")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("pyhpwpokayhbdaie")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of blob storage event type to process.
     */
    @JvmName("tqubwlwvlypvcoxe")
    public suspend fun blobStorageEventType(`value`: Either<String, BlobStorageEventType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobStorageEventType = mapped
    }

    /**
     * @param value The name of blob storage event type to process.
     */
    @JvmName("rbpirccltgecvxus")
    public fun blobStorageEventType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BlobStorageEventType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobStorageEventType = mapped
    }

    /**
     * @param value The name of blob storage event type to process.
     */
    @JvmName("vgbtqpyvhwcqwmnk")
    public fun blobStorageEventType(`value`: BlobStorageEventType) {
        val toBeMapped = Either.ofRight<String, BlobStorageEventType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobStorageEventType = mapped
    }

    /**
     * @param value The event hub consumer group.
     */
    @JvmName("gypjchyaeijnaxkc")
    public suspend fun consumerGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroup = mapped
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("tlsdgjhbygdbwxjo")
    public suspend fun dataConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataConnectionName = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("ddbmjcrkcpmvajrv")
    public suspend fun dataFormat(`value`: Either<String, EventGridDataFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("cybryeybfltbryrq")
    public fun dataFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventGridDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("roqtiwblokihmibm")
    public fun dataFormat(`value`: EventGridDataFormat) {
        val toBeMapped = Either.ofRight<String, EventGridDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("rphkunavtswoqpdn")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The resource ID where the event grid is configured to send events.
     */
    @JvmName("fpsaknuprucjfmxb")
    public suspend fun eventHubResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubResourceId = mapped
    }

    /**
     * @param value A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file
     */
    @JvmName("cqlxfdtebnticejx")
    public suspend fun ignoreFirstRecord(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreFirstRecord = mapped
    }

    /**
     * @param value Kind of the endpoint for the data connection
     * Expected value is 'EventGrid'.
     */
    @JvmName("yisetsqjggydipji")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("rotjrrapcbjrplqt")
    public suspend fun kustoPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kustoPoolName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("wqvtoyelyjlpnxhu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    @JvmName("qmlkaxpatvlrubqv")
    public suspend fun mappingRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappingRuleName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dgwsnsqcbmnrhxmy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource ID of the storage account where the data resides.
     */
    @JvmName("wtvdnqtochbbxisc")
    public suspend fun storageAccountResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountResourceId = mapped
    }

    /**
     * @param value The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    @JvmName("ulofgaijvslmunoh")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("drotkblkashabpqt")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): EventGridDataConnectionArgs = EventGridDataConnectionArgs(
        blobStorageEventType = blobStorageEventType,
        consumerGroup = consumerGroup,
        dataConnectionName = dataConnectionName,
        dataFormat = dataFormat,
        databaseName = databaseName,
        eventHubResourceId = eventHubResourceId,
        ignoreFirstRecord = ignoreFirstRecord,
        kind = kind,
        kustoPoolName = kustoPoolName,
        location = location,
        mappingRuleName = mappingRuleName,
        resourceGroupName = resourceGroupName,
        storageAccountResourceId = storageAccountResourceId,
        tableName = tableName,
        workspaceName = workspaceName,
    )
}
